// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_HINTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_HINTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT HandwritingHints : public bindings::InputDictionaryBase {
  
  public:
static HandwritingHints* Create() {
  return MakeGarbageCollected<HandwritingHints>();
}
static HandwritingHints* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HandwritingHints>(isolate);
}
static HandwritingHints* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HandwritingHints();
explicit  HandwritingHints(v8::Isolate* isolate);

bool hasAlternatives() const {
  return true;
}
uint32_t alternatives() const {
  return member_alternatives_;
}
void setAlternatives(uint32_t value) {
  member_alternatives_ = value;
}

bool hasInputType() const {
  return true;
}
const String& inputType() const {
  return member_input_type_;
}
void setInputType(const String& value);
void setInputType(String&& value);

bool hasRecognitionType() const {
  return true;
}
const String& recognitionType() const {
  return member_recognition_type_;
}
void setRecognitionType(const String& value);
void setRecognitionType(String&& value);

bool hasTextContext() const {
  return has_text_context_;
}
const String& textContext() const {
  DCHECK(hasTextContext());
return member_text_context_;
}
String getTextContextOr(const String& fallback_value) const;
String getTextContextOr(String&& fallback_value) const;
void setTextContext(const String& value);
void setTextContext(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_text_context_ = false;

uint32_t member_alternatives_{3};
String member_input_type_{"mouse"};
String member_recognition_type_{"text"};
String member_text_context_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_HINTS_H_
