// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_VERTEX_STATE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_VERTEX_STATE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_programmable_stage.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUVertexBufferLayout;

class MODULES_EXPORT GPUVertexState : public GPUProgrammableStage {
  
  public:
static GPUVertexState* Create() {
  return MakeGarbageCollected<GPUVertexState>();
}
static GPUVertexState* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUVertexState>(isolate);
}
static GPUVertexState* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUVertexState();
explicit  GPUVertexState(v8::Isolate* isolate);

bool hasBuffers() const {
  return true;
}
const HeapVector<Member<GPUVertexBufferLayout>>& buffers() const {
  return member_buffers_;
}
void setBuffers(const HeapVector<Member<GPUVertexBufferLayout>>& value);
void setBuffers(HeapVector<Member<GPUVertexBufferLayout>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUProgrammableStage::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



HeapVector<Member<GPUVertexBufferLayout>> member_buffers_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_VERTEX_STATE_H_
