// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXTURE_BINDING_LAYOUT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXTURE_BINDING_LAYOUT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_sample_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_view_dimension.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUTextureBindingLayout : public bindings::InputDictionaryBase {
  
  public:
static GPUTextureBindingLayout* Create() {
  return MakeGarbageCollected<GPUTextureBindingLayout>();
}
static GPUTextureBindingLayout* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUTextureBindingLayout>(isolate);
}
static GPUTextureBindingLayout* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUTextureBindingLayout();
explicit  GPUTextureBindingLayout(v8::Isolate* isolate);

bool hasMultisampled() const {
  return true;
}
bool multisampled() const {
  return member_multisampled_;
}
void setMultisampled(bool value) {
  member_multisampled_ = value;
}

bool hasSampleType() const {
  return true;
}
V8GPUTextureSampleType sampleType() const {
  return member_sample_type_;
}
void setSampleType(V8GPUTextureSampleType value) {
  member_sample_type_ = value;
}
void setSampleType(V8GPUTextureSampleType::Enum value) {
  member_sample_type_ = V8GPUTextureSampleType(value);
}

bool hasViewDimension() const {
  return true;
}
V8GPUTextureViewDimension viewDimension() const {
  return member_view_dimension_;
}
void setViewDimension(V8GPUTextureViewDimension value) {
  member_view_dimension_ = value;
}
void setViewDimension(V8GPUTextureViewDimension::Enum value) {
  member_view_dimension_ = V8GPUTextureViewDimension(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_multisampled_{false};
V8GPUTextureSampleType member_sample_type_{V8GPUTextureSampleType::Enum::kFloat};
V8GPUTextureViewDimension member_view_dimension_{V8GPUTextureViewDimension::Enum::k2D};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXTURE_BINDING_LAYOUT_H_
