// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_SHADER_MODULE_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_SHADER_MODULE_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class GPUShaderModuleCompilationHint;

class MODULES_EXPORT GPUShaderModuleDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUShaderModuleDescriptor* Create() {
  return MakeGarbageCollected<GPUShaderModuleDescriptor>();
}
static GPUShaderModuleDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUShaderModuleDescriptor>(isolate);
}
static GPUShaderModuleDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUShaderModuleDescriptor();
explicit  GPUShaderModuleDescriptor(v8::Isolate* isolate);

bool hasCode() const {
  return true;
}
const String& code() const {
  return member_code_;
}
void setCode(const String& value);
void setCode(String&& value);

bool hasCompilationHints() const {
  return true;
}
const HeapVector<Member<GPUShaderModuleCompilationHint>>& compilationHints() const {
  return member_compilation_hints_;
}
void setCompilationHints(const HeapVector<Member<GPUShaderModuleCompilationHint>>& value);
void setCompilationHints(HeapVector<Member<GPUShaderModuleCompilationHint>>&& value);

bool hasStrictMath() const {
  return has_strict_math_;
}
bool strictMath() const {
  DCHECK(hasStrictMath());
return member_strict_math_;
}
bool getStrictMathOr(bool fallback_value) const {
  if (!hasStrictMath()) {
  return fallback_value;
}
return member_strict_math_;
}
void setStrictMath(bool value) {
  member_strict_math_ = value;
has_strict_math_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_strict_math_ = false;

String member_code_;
HeapVector<Member<GPUShaderModuleCompilationHint>> member_compilation_hints_;
bool member_strict_math_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_SHADER_MODULE_DESCRIPTOR_H_
