// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_sampler_descriptor.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"addressModeU",
"addressModeV",
"addressModeW",
"compare",
"lodMaxClamp",
"lodMinClamp",
"magFilter",
"maxAnisotropy",
"minFilter",
"mipmapFilter",
};


}  // namespace 

GPUSamplerDescriptor* GPUSamplerDescriptor::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GPUSamplerDescriptor* dictionary = MakeGarbageCollected<GPUSamplerDescriptor>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GPUSamplerDescriptor";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GPUSamplerDescriptor::GPUSamplerDescriptor() {
  
}

 GPUSamplerDescriptor::GPUSamplerDescriptor(v8::Isolate* isolate) : GPUObjectDescriptorBase(isolate) {
  
}























































void GPUSamplerDescriptor::Trace(Visitor* visitor) const {
  GPUObjectDescriptorBase::Trace(visitor);
}

void GPUSamplerDescriptor::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
GPUObjectDescriptorBase::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "GPUSamplerDescriptor";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("addressModeU");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUAddressMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_address_mode_u_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("addressModeV");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUAddressMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_address_mode_v_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("addressModeW");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUAddressMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_address_mode_w_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("compare");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUCompareFunction, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_compare_, member_compare_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lodMaxClamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLFloat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_lod_max_clamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lodMinClamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLFloat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_lod_min_clamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("magFilter");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUFilterMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_mag_filter_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("maxAnisotropy");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShortClamp, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_max_anisotropy_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("minFilter");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUFilterMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_min_filter_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mipmapFilter");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUMipmapFilterMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_mipmap_filter_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GPUSamplerDescriptor::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
