// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pipeline_descriptor.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_depth_stencil_state.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_fragment_state.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_multisample_state.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_primitive_state.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_vertex_state.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"depthStencil",
"fragment",
"multisample",
"primitive",
"vertex",
};


}  // namespace 

GPURenderPipelineDescriptor* GPURenderPipelineDescriptor::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GPURenderPipelineDescriptor* dictionary = MakeGarbageCollected<GPURenderPipelineDescriptor>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GPURenderPipelineDescriptor";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GPURenderPipelineDescriptor::GPURenderPipelineDescriptor() : member_multisample_(GPUMultisampleState::Create()), member_primitive_(GPUPrimitiveState::Create()) {
  
}

 GPURenderPipelineDescriptor::GPURenderPipelineDescriptor(v8::Isolate* isolate) : GPUPipelineDescriptorBase(isolate), member_multisample_(GPUMultisampleState::Create()), member_primitive_(GPUPrimitiveState::Create()) {
  
}
































void GPURenderPipelineDescriptor::Trace(Visitor* visitor) const {
  visitor->Trace(member_depth_stencil_);
visitor->Trace(member_fragment_);
visitor->Trace(member_multisample_);
visitor->Trace(member_primitive_);
visitor->Trace(member_vertex_);
GPUPipelineDescriptorBase::Trace(visitor);
}

void GPURenderPipelineDescriptor::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
GPUPipelineDescriptorBase::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "GPURenderPipelineDescriptor";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("depthStencil");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<GPUDepthStencilState, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_depth_stencil_, member_depth_stencil_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("fragment");
if (!bindings::GetDictionaryMemberFromV8Object<GPUFragmentState, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_fragment_, member_fragment_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("multisample");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<GPUMultisampleState, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_multisample_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("primitive");
if (!bindings::GetDictionaryMemberFromV8Object<GPUPrimitiveState, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_primitive_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("vertex");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<GPUVertexState, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_vertex_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GPURenderPipelineDescriptor::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
