// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_TIMESTAMP_WRITES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_TIMESTAMP_WRITES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUQuerySet;

class MODULES_EXPORT GPURenderPassTimestampWrites : public bindings::InputDictionaryBase {
  
  public:
static GPURenderPassTimestampWrites* Create() {
  return MakeGarbageCollected<GPURenderPassTimestampWrites>();
}
static GPURenderPassTimestampWrites* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPURenderPassTimestampWrites>(isolate);
}
static GPURenderPassTimestampWrites* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPURenderPassTimestampWrites();
explicit  GPURenderPassTimestampWrites(v8::Isolate* isolate);

bool hasBeginningOfPassWriteIndex() const {
  return has_beginning_of_pass_write_index_;
}
uint32_t beginningOfPassWriteIndex() const {
  DCHECK(hasBeginningOfPassWriteIndex());
return member_beginning_of_pass_write_index_;
}
uint32_t getBeginningOfPassWriteIndexOr(uint32_t fallback_value) const {
  if (!hasBeginningOfPassWriteIndex()) {
  return fallback_value;
}
return member_beginning_of_pass_write_index_;
}
void setBeginningOfPassWriteIndex(uint32_t value) {
  member_beginning_of_pass_write_index_ = value;
has_beginning_of_pass_write_index_ = true;
}

bool hasEndOfPassWriteIndex() const {
  return has_end_of_pass_write_index_;
}
uint32_t endOfPassWriteIndex() const {
  DCHECK(hasEndOfPassWriteIndex());
return member_end_of_pass_write_index_;
}
uint32_t getEndOfPassWriteIndexOr(uint32_t fallback_value) const {
  if (!hasEndOfPassWriteIndex()) {
  return fallback_value;
}
return member_end_of_pass_write_index_;
}
void setEndOfPassWriteIndex(uint32_t value) {
  member_end_of_pass_write_index_ = value;
has_end_of_pass_write_index_ = true;
}

bool hasQuerySet() const {
  return true;
}
GPUQuerySet* querySet() const {
  return member_query_set_.Get();
}
void setQuerySet(GPUQuerySet* value) {
  member_query_set_ = value;
DCHECK(member_query_set_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_beginning_of_pass_write_index_ = false;
bool has_end_of_pass_write_index_ = false;

uint32_t member_beginning_of_pass_write_index_;
uint32_t member_end_of_pass_write_index_;
Member<GPUQuerySet> member_query_set_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_TIMESTAMP_WRITES_H_
