// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_DEPTH_STENCIL_ATTACHMENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_DEPTH_STENCIL_ATTACHMENT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_load_op.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_store_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUTexture;
class GPUTextureView;
class V8UnionGPUTextureOrGPUTextureView;

class MODULES_EXPORT GPURenderPassDepthStencilAttachment : public bindings::InputDictionaryBase {
  
  public:
static GPURenderPassDepthStencilAttachment* Create() {
  return MakeGarbageCollected<GPURenderPassDepthStencilAttachment>();
}
static GPURenderPassDepthStencilAttachment* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPURenderPassDepthStencilAttachment>(isolate);
}
static GPURenderPassDepthStencilAttachment* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPURenderPassDepthStencilAttachment();
explicit  GPURenderPassDepthStencilAttachment(v8::Isolate* isolate);

bool hasDepthClearValue() const {
  return has_depth_clear_value_;
}
float depthClearValue() const {
  DCHECK(hasDepthClearValue());
return member_depth_clear_value_;
}
float getDepthClearValueOr(float fallback_value) const {
  if (!hasDepthClearValue()) {
  return fallback_value;
}
return member_depth_clear_value_;
}
void setDepthClearValue(float value) {
  member_depth_clear_value_ = value;
has_depth_clear_value_ = true;
}

bool hasDepthLoadOp() const {
  return has_depth_load_op_;
}
V8GPULoadOp depthLoadOp() const {
  DCHECK(hasDepthLoadOp());
return member_depth_load_op_;
}
V8GPULoadOp getDepthLoadOpOr(V8GPULoadOp fallback_value) const {
  if (!hasDepthLoadOp()) {
  return fallback_value;
}
return member_depth_load_op_;
}
void setDepthLoadOp(V8GPULoadOp value) {
  member_depth_load_op_ = value;
has_depth_load_op_ = true;
}
void setDepthLoadOp(V8GPULoadOp::Enum value) {
  member_depth_load_op_ = V8GPULoadOp(value);
has_depth_load_op_ = true;
}

bool hasDepthReadOnly() const {
  return true;
}
bool depthReadOnly() const {
  return member_depth_read_only_;
}
void setDepthReadOnly(bool value) {
  member_depth_read_only_ = value;
}

bool hasDepthStoreOp() const {
  return has_depth_store_op_;
}
V8GPUStoreOp depthStoreOp() const {
  DCHECK(hasDepthStoreOp());
return member_depth_store_op_;
}
V8GPUStoreOp getDepthStoreOpOr(V8GPUStoreOp fallback_value) const {
  if (!hasDepthStoreOp()) {
  return fallback_value;
}
return member_depth_store_op_;
}
void setDepthStoreOp(V8GPUStoreOp value) {
  member_depth_store_op_ = value;
has_depth_store_op_ = true;
}
void setDepthStoreOp(V8GPUStoreOp::Enum value) {
  member_depth_store_op_ = V8GPUStoreOp(value);
has_depth_store_op_ = true;
}

bool hasStencilClearValue() const {
  return true;
}
uint32_t stencilClearValue() const {
  return member_stencil_clear_value_;
}
void setStencilClearValue(uint32_t value) {
  member_stencil_clear_value_ = value;
}

bool hasStencilLoadOp() const {
  return has_stencil_load_op_;
}
V8GPULoadOp stencilLoadOp() const {
  DCHECK(hasStencilLoadOp());
return member_stencil_load_op_;
}
V8GPULoadOp getStencilLoadOpOr(V8GPULoadOp fallback_value) const {
  if (!hasStencilLoadOp()) {
  return fallback_value;
}
return member_stencil_load_op_;
}
void setStencilLoadOp(V8GPULoadOp value) {
  member_stencil_load_op_ = value;
has_stencil_load_op_ = true;
}
void setStencilLoadOp(V8GPULoadOp::Enum value) {
  member_stencil_load_op_ = V8GPULoadOp(value);
has_stencil_load_op_ = true;
}

bool hasStencilReadOnly() const {
  return true;
}
bool stencilReadOnly() const {
  return member_stencil_read_only_;
}
void setStencilReadOnly(bool value) {
  member_stencil_read_only_ = value;
}

bool hasStencilStoreOp() const {
  return has_stencil_store_op_;
}
V8GPUStoreOp stencilStoreOp() const {
  DCHECK(hasStencilStoreOp());
return member_stencil_store_op_;
}
V8GPUStoreOp getStencilStoreOpOr(V8GPUStoreOp fallback_value) const {
  if (!hasStencilStoreOp()) {
  return fallback_value;
}
return member_stencil_store_op_;
}
void setStencilStoreOp(V8GPUStoreOp value) {
  member_stencil_store_op_ = value;
has_stencil_store_op_ = true;
}
void setStencilStoreOp(V8GPUStoreOp::Enum value) {
  member_stencil_store_op_ = V8GPUStoreOp(value);
has_stencil_store_op_ = true;
}

bool hasView() const {
  return true;
}
V8UnionGPUTextureOrGPUTextureView* view() const {
  return member_view_.Get();
}
void setView(V8UnionGPUTextureOrGPUTextureView* value) {
  member_view_ = value;
DCHECK(member_view_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 9;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_depth_clear_value_ = false;
bool has_depth_load_op_ = false;
bool has_depth_store_op_ = false;
bool has_stencil_load_op_ = false;
bool has_stencil_store_op_ = false;

float member_depth_clear_value_;
V8GPULoadOp member_depth_load_op_{static_cast<V8GPULoadOp::Enum>(0)};
bool member_depth_read_only_{false};
V8GPUStoreOp member_depth_store_op_{static_cast<V8GPUStoreOp::Enum>(0)};
uint32_t member_stencil_clear_value_{0};
V8GPULoadOp member_stencil_load_op_{static_cast<V8GPULoadOp::Enum>(0)};
bool member_stencil_read_only_{false};
V8GPUStoreOp member_stencil_store_op_{static_cast<V8GPUStoreOp::Enum>(0)};
Member<V8UnionGPUTextureOrGPUTextureView> member_view_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_RENDER_PASS_DEPTH_STENCIL_ATTACHMENT_H_
