// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_IMAGE_COPY_EXTERNAL_IMAGE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_IMAGE_COPY_EXTERNAL_IMAGE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUOrigin2DDict;
class HTMLCanvasElement;
class HTMLImageElement;
class HTMLVideoElement;
class ImageBitmap;
class ImageData;
class OffscreenCanvas;
class V8UnionGPUOrigin2DDictOrUnsignedLongEnforceRangeSequence;
class V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame;
class VideoFrame;

class MODULES_EXPORT GPUImageCopyExternalImage : public bindings::InputDictionaryBase {
  
  public:
static GPUImageCopyExternalImage* Create() {
  return MakeGarbageCollected<GPUImageCopyExternalImage>();
}
static GPUImageCopyExternalImage* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUImageCopyExternalImage>(isolate);
}
static GPUImageCopyExternalImage* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUImageCopyExternalImage();
explicit  GPUImageCopyExternalImage(v8::Isolate* isolate);

bool hasFlipY() const {
  return true;
}
bool flipY() const {
  return member_flip_y_;
}
void setFlipY(bool value) {
  member_flip_y_ = value;
}

bool hasOrigin() const {
  return true;
}
V8UnionGPUOrigin2DDictOrUnsignedLongEnforceRangeSequence* origin() const {
  return member_origin_.Get();
}
void setOrigin(V8UnionGPUOrigin2DDictOrUnsignedLongEnforceRangeSequence* value) {
  member_origin_ = value;
DCHECK(member_origin_);
}

bool hasSource() const {
  return true;
}
V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* source() const {
  return member_source_.Get();
}
void setSource(V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* value) {
  member_source_ = value;
DCHECK(member_source_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_flip_y_{false};
Member<V8UnionGPUOrigin2DDictOrUnsignedLongEnforceRangeSequence> member_origin_;
Member<V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame> member_source_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_IMAGE_COPY_EXTERNAL_IMAGE_H_
