// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_COMPUTE_PASS_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_COMPUTE_PASS_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUComputePassTimestampWrites;

class MODULES_EXPORT GPUComputePassDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUComputePassDescriptor* Create() {
  return MakeGarbageCollected<GPUComputePassDescriptor>();
}
static GPUComputePassDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUComputePassDescriptor>(isolate);
}
static GPUComputePassDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUComputePassDescriptor();
explicit  GPUComputePassDescriptor(v8::Isolate* isolate);

bool hasTimestampWrites() const {
  return has_timestamp_writes_;
}
GPUComputePassTimestampWrites* timestampWrites() const {
  DCHECK(hasTimestampWrites());
return member_timestamp_writes_.Get();
}
GPUComputePassTimestampWrites* getTimestampWritesOr(GPUComputePassTimestampWrites* fallback_value) const {
  if (!hasTimestampWrites()) {
  return fallback_value;
}
return member_timestamp_writes_.Get();
}
void setTimestampWrites(GPUComputePassTimestampWrites* value) {
  member_timestamp_writes_ = value;
has_timestamp_writes_ = true;
DCHECK(member_timestamp_writes_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_timestamp_writes_ = false;

Member<GPUComputePassTimestampWrites> member_timestamp_writes_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_COMPUTE_PASS_DESCRIPTOR_H_
