// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_CANVAS_CONFIGURATION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_CANVAS_CONFIGURATION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_predefined_color_space.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_canvas_alpha_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUCanvasToneMapping;
class GPUDevice;

class MODULES_EXPORT GPUCanvasConfiguration : public bindings::DictionaryBase {
  
  public:
static GPUCanvasConfiguration* Create() {
  return MakeGarbageCollected<GPUCanvasConfiguration>();
}
static GPUCanvasConfiguration* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUCanvasConfiguration>(isolate);
}
static GPUCanvasConfiguration* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUCanvasConfiguration();
explicit  GPUCanvasConfiguration(v8::Isolate* isolate);

bool hasAlphaMode() const {
  return true;
}
V8GPUCanvasAlphaMode alphaMode() const {
  return member_alpha_mode_;
}
void setAlphaMode(V8GPUCanvasAlphaMode value) {
  member_alpha_mode_ = value;
}
void setAlphaMode(V8GPUCanvasAlphaMode::Enum value) {
  member_alpha_mode_ = V8GPUCanvasAlphaMode(value);
}

bool hasColorSpace() const {
  return true;
}
V8PredefinedColorSpace colorSpace() const {
  return member_color_space_;
}
void setColorSpace(V8PredefinedColorSpace value) {
  member_color_space_ = value;
}
void setColorSpace(V8PredefinedColorSpace::Enum value) {
  member_color_space_ = V8PredefinedColorSpace(value);
}

bool hasDevice() const {
  return true;
}
GPUDevice* device() const {
  return member_device_.Get();
}
void setDevice(GPUDevice* value) {
  member_device_ = value;
DCHECK(member_device_);
}

bool hasFormat() const {
  return true;
}
V8GPUTextureFormat format() const {
  return member_format_;
}
void setFormat(V8GPUTextureFormat value) {
  member_format_ = value;
}
void setFormat(V8GPUTextureFormat::Enum value) {
  member_format_ = V8GPUTextureFormat(value);
}

bool hasToneMapping() const {
  return true;
}
GPUCanvasToneMapping* toneMapping() const {
  return member_tone_mapping_.Get();
}
void setToneMapping(GPUCanvasToneMapping* value) {
  member_tone_mapping_ = value;
DCHECK(member_tone_mapping_);
}

bool hasUsage() const {
  return true;
}
uint32_t usage() const {
  return member_usage_;
}
void setUsage(uint32_t value) {
  member_usage_ = value;
}

bool hasViewFormats() const {
  return true;
}
const Vector<V8GPUTextureFormat>& viewFormats() const {
  return member_view_formats_;
}
void setViewFormats(const Vector<V8GPUTextureFormat>& value);
void setViewFormats(Vector<V8GPUTextureFormat>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8GPUCanvasAlphaMode member_alpha_mode_{V8GPUCanvasAlphaMode::Enum::kOpaque};
V8PredefinedColorSpace member_color_space_{V8PredefinedColorSpace::Enum::kSRGB};
Member<GPUDevice> member_device_;
V8GPUTextureFormat member_format_{static_cast<V8GPUTextureFormat::Enum>(0)};
Member<GPUCanvasToneMapping> member_tone_mapping_;
uint32_t member_usage_{16};
Vector<V8GPUTextureFormat> member_view_formats_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_CANVAS_CONFIGURATION_H_
