// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BUFFER_BINDING_LAYOUT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BUFFER_BINDING_LAYOUT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer_binding_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUBufferBindingLayout : public bindings::InputDictionaryBase {
  
  public:
static GPUBufferBindingLayout* Create() {
  return MakeGarbageCollected<GPUBufferBindingLayout>();
}
static GPUBufferBindingLayout* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUBufferBindingLayout>(isolate);
}
static GPUBufferBindingLayout* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUBufferBindingLayout();
explicit  GPUBufferBindingLayout(v8::Isolate* isolate);

bool hasHasDynamicOffset() const {
  return true;
}
bool hasDynamicOffset() const {
  return member_has_dynamic_offset_;
}
void setHasDynamicOffset(bool value) {
  member_has_dynamic_offset_ = value;
}

bool hasMinBindingSize() const {
  return true;
}
uint64_t minBindingSize() const {
  return member_min_binding_size_;
}
void setMinBindingSize(uint64_t value) {
  member_min_binding_size_ = value;
}

bool hasType() const {
  return true;
}
V8GPUBufferBindingType type() const {
  return member_type_;
}
void setType(V8GPUBufferBindingType value) {
  member_type_ = value;
}
void setType(V8GPUBufferBindingType::Enum value) {
  member_type_ = V8GPUBufferBindingType(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_has_dynamic_offset_{false};
uint64_t member_min_binding_size_{0};
V8GPUBufferBindingType member_type_{V8GPUBufferBindingType::Enum::kUniform};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BUFFER_BINDING_LAYOUT_H_
