// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BIND_GROUP_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BIND_GROUP_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUBindGroupEntry;
class GPUBindGroupLayout;

class MODULES_EXPORT GPUBindGroupDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUBindGroupDescriptor* Create() {
  return MakeGarbageCollected<GPUBindGroupDescriptor>();
}
static GPUBindGroupDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUBindGroupDescriptor>(isolate);
}
static GPUBindGroupDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUBindGroupDescriptor();
explicit  GPUBindGroupDescriptor(v8::Isolate* isolate);

bool hasEntries() const {
  return true;
}
const HeapVector<Member<GPUBindGroupEntry>>& entries() const {
  return member_entries_;
}
void setEntries(const HeapVector<Member<GPUBindGroupEntry>>& value);
void setEntries(HeapVector<Member<GPUBindGroupEntry>>&& value);

bool hasLayout() const {
  return true;
}
GPUBindGroupLayout* layout() const {
  return member_layout_.Get();
}
void setLayout(GPUBindGroupLayout* value) {
  member_layout_ = value;
DCHECK(member_layout_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



HeapVector<Member<GPUBindGroupEntry>> member_entries_;
Member<GPUBindGroupLayout> member_layout_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BIND_GROUP_DESCRIPTOR_H_
