// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_handle.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_permission_state.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_cloud_identifier.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_directory_handle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_handle_kind.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_handle_permission_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_remove_options.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/modules/file_system_access/file_system_directory_handle.h"
#include "third_party/blink/renderer/modules/file_system_access/file_system_handle.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8FileSystemHandle::IsExposed(ExecutionContext* execution_context) {
  
const bool is_in_secure_context = execution_context->IsSecureContext();
return is_in_secure_context && (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) && RuntimeEnabledFeatures::FileSystemAccessEnabled();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8FileSystemHandle::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8FileSystemHandle::InstallInterfaceTemplate,
    nullptr,
    "FileSystemHandle",
    nullptr,
    V8FileSystemHandle::kThisTag,
    V8FileSystemHandle::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& FileSystemHandle::wrapper_type_info_ =
    V8FileSystemHandle::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, FileSystemHandle>::value,
    "FileSystemHandle inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_file_system_handle {


void KindAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FileSystemHandle_kind_Getter");
BLINK_BINDINGS_TRACE_EVENT("FileSystemHandle.kind.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->kind();
static_assert(bindings::IsReturnTypeCompatible<V8FileSystemHandleKind, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}



void NameAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FileSystemHandle_name_Getter");
BLINK_BINDINGS_TRACE_EVENT("FileSystemHandle.name.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->name();
static_assert(bindings::IsReturnTypeCompatible<IDLUSVString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}


void GetCloudIdentifiersOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FileSystemHandle_getCloudIdentifiers");
BLINK_BINDINGS_TRACE_EVENT("FileSystemHandle.getCloudIdentifiers");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8FileSystemHandle::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8FileSystemHandle_GetCloudIdentifiers_Method);




FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "FileSystemHandle";
const char* const property_name = "getCloudIdentifiers";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = blink_receiver->getCloudIdentifiers(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLSequence<FileSystemCloudIdentifier>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void GetUniqueIdOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FileSystemHandle_getUniqueId");
BLINK_BINDINGS_TRACE_EVENT("FileSystemHandle.getUniqueId");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8FileSystemHandle::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8FileSystemHandle_GetUniqueId_Method);




FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "FileSystemHandle";
const char* const property_name = "getUniqueId";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = blink_receiver->getUniqueId(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUSVString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void IsSameEntryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FileSystemHandle_isSameEntry");
BLINK_BINDINGS_TRACE_EVENT("FileSystemHandle.isSameEntry");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8FileSystemHandle::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8FileSystemHandle_IsSameEntry_Method);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "FileSystemHandle";
const char* const property_name = "isSameEntry";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_other = NativeValueTraits<FileSystemHandle>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isSameEntry(script_state, arg1_other, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLBoolean>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void MoveOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8FileSystemHandle::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}



if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "FileSystemHandle";
const char* const property_name = "move";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_new_entry_name = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->move(script_state, arg1_new_entry_name, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void MoveOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8FileSystemHandle::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}



if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "FileSystemHandle";
const char* const property_name = "move";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_destination_directory = NativeValueTraits<FileSystemDirectoryHandle>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->move(script_state, arg1_destination_directory, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void MoveOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8FileSystemHandle::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}



if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "FileSystemHandle";
const char* const property_name = "move";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_destination_directory = NativeValueTraits<FileSystemDirectoryHandle>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_new_entry_name = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->move(script_state, arg1_destination_directory, arg2_new_entry_name, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void MoveOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  // Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FileSystemHandle_move");
BLINK_BINDINGS_TRACE_EVENT("FileSystemHandle.move");


const int arg_count = std::min(info.Length(), 2);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  if (RuntimeEnabledFeatures::FileSystemAccessAPIExperimentalEnabled()) {
  if (arg_count == 2) {
  return MoveOperationOverload3(info);
}
}
if (RuntimeEnabledFeatures::FileSystemAccessAPIExperimentalEnabled()) {
  if (arg_count == 1) {
  if (info[0]->IsObject()) {
  if (RuntimeEnabledFeatures::FileSystemAccessAPIExperimentalEnabled()) {
  if (V8FileSystemDirectoryHandle::HasInstance(isolate, info[0])) {
  return MoveOperationOverload2(info);
}
}
}
if (RuntimeEnabledFeatures::FileSystemAccessAPIExperimentalEnabled()) {
  return MoveOperationOverload1(info);
}
break;
}
}
} while (false);

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void QueryPermissionOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FileSystemHandle_queryPermission");
BLINK_BINDINGS_TRACE_EVENT("FileSystemHandle.queryPermission");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8FileSystemHandle::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}





FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
decltype(NativeValueTraits<FileSystemHandlePermissionDescriptor>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_descriptor;
if (info[0]->IsUndefined()) {
  arg1_descriptor = FileSystemHandlePermissionDescriptor::Create();
} else {
  const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "FileSystemHandle";
const char* const property_name = "queryPermission";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
arg1_descriptor = NativeValueTraits<FileSystemHandlePermissionDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->queryPermission(script_state, arg1_descriptor);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<V8PermissionState>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void RemoveOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FileSystemHandle_remove");
BLINK_BINDINGS_TRACE_EVENT("FileSystemHandle.remove");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8FileSystemHandle::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8FileSystemHandle_Remove_Method);




FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
decltype(NativeValueTraits<FileSystemRemoveOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_options;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "FileSystemHandle";
const char* const property_name = "remove";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
if (info[0]->IsUndefined()) {
  arg1_options = FileSystemRemoveOptions::Create();
} else {
  arg1_options = NativeValueTraits<FileSystemRemoveOptions>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->remove(script_state, arg1_options, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void RequestPermissionOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_FileSystemHandle_requestPermission");
BLINK_BINDINGS_TRACE_EVENT("FileSystemHandle.requestPermission");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8FileSystemHandle::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}





FileSystemHandle* blink_receiver = V8FileSystemHandle::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
decltype(NativeValueTraits<FileSystemHandlePermissionDescriptor>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_descriptor;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "FileSystemHandle";
const char* const property_name = "requestPermission";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
if (info[0]->IsUndefined()) {
  arg1_descriptor = FileSystemHandlePermissionDescriptor::Create();
} else {
  arg1_descriptor = NativeValueTraits<FileSystemHandlePermissionDescriptor>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->requestPermission(script_state, arg1_descriptor, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<V8PermissionState>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}


}  // namespace v8_file_system_handle

using namespace v8_file_system_handle;

}  // namespace 

void V8FileSystemHandle::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8FileSystemHandle::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8FileSystemHandle::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"kind", KindAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"name", NameAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "FileSystemHandle", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"isSameEntry", IsSameEntryOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"queryPermission", QueryPermissionOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"remove", RemoveOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"requestPermission", RequestPermissionOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "FileSystemHandle", kOperationTable);
}



}

void V8FileSystemHandle::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;





v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::FileSystemAccessGetCloudIdentifiersEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getCloudIdentifiers", GetCloudIdentifiersOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "FileSystemHandle", kOperationTable);
}
if (RuntimeEnabledFeatures::FileSystemAccessAPIExperimentalEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getUniqueId", GetUniqueIdOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"move", MoveOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "FileSystemHandle", kOperationTable);
}


}



}  // namespace blink
