// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_CHANGE_RECORD_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_CHANGE_RECORD_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_change_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class FileSystemHandle;

class MODULES_EXPORT FileSystemChangeRecord : public bindings::DictionaryBase {
  
  public:
static FileSystemChangeRecord* Create() {
  return MakeGarbageCollected<FileSystemChangeRecord>();
}
static FileSystemChangeRecord* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FileSystemChangeRecord>(isolate);
}
static FileSystemChangeRecord* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FileSystemChangeRecord();
explicit  FileSystemChangeRecord(v8::Isolate* isolate);

bool hasChangedHandle() const {
  return has_changed_handle_;
}
FileSystemHandle* changedHandle() const {
  DCHECK(hasChangedHandle());
return member_changed_handle_.Get();
}
FileSystemHandle* getChangedHandleOr(FileSystemHandle* fallback_value) const {
  if (!hasChangedHandle()) {
  return fallback_value;
}
return member_changed_handle_.Get();
}
void setChangedHandle(FileSystemHandle* value) {
  member_changed_handle_ = value;
has_changed_handle_ = true;
}

bool hasRelativePathComponents() const {
  return has_relative_path_components_;
}
const Vector<String>& relativePathComponents() const {
  DCHECK(hasRelativePathComponents());
return member_relative_path_components_;
}
Vector<String> getRelativePathComponentsOr(const Vector<String>& fallback_value) const;
Vector<String> getRelativePathComponentsOr(Vector<String>&& fallback_value) const;
void setRelativePathComponents(const Vector<String>& value);
void setRelativePathComponents(Vector<String>&& value);

bool hasRelativePathMovedFrom() const {
  return has_relative_path_moved_from_;
}
const std::optional<Vector<String>>& relativePathMovedFrom() const {
  DCHECK(hasRelativePathMovedFrom());
return member_relative_path_moved_from_;
}
std::optional<Vector<String>> getRelativePathMovedFromOr(const std::optional<Vector<String>>& fallback_value) const;
std::optional<Vector<String>> getRelativePathMovedFromOr(std::optional<Vector<String>>&& fallback_value) const;
void setRelativePathMovedFrom(const std::optional<Vector<String>>& value);
void setRelativePathMovedFrom(std::optional<Vector<String>>&& value);
void setRelativePathMovedFrom(const Vector<String>& value);
void setRelativePathMovedFrom(Vector<String>&& value);

bool hasRoot() const {
  return has_root_;
}
FileSystemHandle* root() const {
  DCHECK(hasRoot());
return member_root_.Get();
}
FileSystemHandle* getRootOr(FileSystemHandle* fallback_value) const {
  if (!hasRoot()) {
  return fallback_value;
}
return member_root_.Get();
}
void setRoot(FileSystemHandle* value) {
  member_root_ = value;
has_root_ = true;
DCHECK(member_root_);
}

bool hasType() const {
  return has_type_;
}
V8FileSystemChangeType type() const {
  DCHECK(hasType());
return member_type_;
}
V8FileSystemChangeType getTypeOr(V8FileSystemChangeType fallback_value) const {
  if (!hasType()) {
  return fallback_value;
}
return member_type_;
}
void setType(V8FileSystemChangeType value) {
  member_type_ = value;
has_type_ = true;
}
void setType(V8FileSystemChangeType::Enum value) {
  member_type_ = V8FileSystemChangeType(value);
has_type_ = true;
}


// Obsolete accessor functions
bool hasRelativePathMovedFromNonNull() const {
  return hasRelativePathMovedFrom() && relativePathMovedFrom().has_value();
}
const Vector<String>& relativePathMovedFromNonNull() const {
  DCHECK(hasRelativePathMovedFromNonNull());
return relativePathMovedFrom().value();
}

void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_changed_handle_ = false;
bool has_relative_path_components_ = false;
bool has_relative_path_moved_from_ = false;
bool has_root_ = false;
bool has_type_ = false;

Member<FileSystemHandle> member_changed_handle_;
Vector<String> member_relative_path_components_;
std::optional<Vector<String>> member_relative_path_moved_from_;
Member<FileSystemHandle> member_root_;
V8FileSystemChangeType member_type_{static_cast<V8FileSystemChangeType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_SYSTEM_CHANGE_RECORD_H_
