// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_file_picker_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_picker_accept_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_filesystemhandle_wellknowndirectory.h"
#include "third_party/blink/renderer/modules/file_system_access/file_system_handle.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"excludeAcceptAllOption",
"id",
"startIn",
"types",
};


}  // namespace 

FilePickerOptions* FilePickerOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  FilePickerOptions* dictionary = MakeGarbageCollected<FilePickerOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "FilePickerOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 FilePickerOptions::FilePickerOptions() {
  
}

 FilePickerOptions::FilePickerOptions(v8::Isolate* isolate) {
  
}








String FilePickerOptions::getIdOr(const String& fallback_value) const {
  if (!hasId()) {
  return fallback_value;
}
return member_id_;
}

String FilePickerOptions::getIdOr(String&& fallback_value) const {
  if (!hasId()) {
  return std::move(fallback_value);
}
return member_id_;
}

void FilePickerOptions::setId(const String& value) {
  member_id_ = value;
has_id_ = true;
}

void FilePickerOptions::setId(String&& value) {
  member_id_ = std::move(value);
has_id_ = true;
}











HeapVector<Member<FilePickerAcceptType>> FilePickerOptions::getTypesOr(const HeapVector<Member<FilePickerAcceptType>>& fallback_value) const {
  if (!hasTypes()) {
  return fallback_value;
}
return member_types_;
}

HeapVector<Member<FilePickerAcceptType>> FilePickerOptions::getTypesOr(HeapVector<Member<FilePickerAcceptType>>&& fallback_value) const {
  if (!hasTypes()) {
  return std::move(fallback_value);
}
return member_types_;
}

void FilePickerOptions::setTypes(const HeapVector<Member<FilePickerAcceptType>>& value) {
  member_types_ = value;
has_types_ = true;
}

void FilePickerOptions::setTypes(HeapVector<Member<FilePickerAcceptType>>&& value) {
  member_types_ = std::move(value);
has_types_ = true;
}




void FilePickerOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_start_in_);
visitor->Trace(member_types_);
bindings::InputDictionaryBase::Trace(visitor);
}

void FilePickerOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "FilePickerOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("excludeAcceptAllOption");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_exclude_accept_all_option_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("id");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_id_, member_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("startIn");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionFileSystemHandleOrWellKnownDirectory, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_start_in_, member_start_in_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("types");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<FilePickerAcceptType>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_types_, member_types_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> FilePickerOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
