// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_PICKER_ACCEPT_TYPE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_PICKER_ACCEPT_TYPE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionUSVStringOrUSVStringSequence;

class MODULES_EXPORT FilePickerAcceptType : public bindings::InputDictionaryBase {
  
  public:
static FilePickerAcceptType* Create() {
  return MakeGarbageCollected<FilePickerAcceptType>();
}
static FilePickerAcceptType* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FilePickerAcceptType>(isolate);
}
static FilePickerAcceptType* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FilePickerAcceptType();
explicit  FilePickerAcceptType(v8::Isolate* isolate);

bool hasAccept() const {
  return has_accept_;
}
const HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>>& accept() const {
  DCHECK(hasAccept());
return member_accept_;
}
HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>> getAcceptOr(const HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>>& fallback_value) const;
HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>> getAcceptOr(HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>>&& fallback_value) const;
void setAccept(const HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>>& value);
void setAccept(HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>>&& value);

bool hasDescription() const {
  return true;
}
const String& description() const {
  return member_description_;
}
void setDescription(const String& value);
void setDescription(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_accept_ = false;

HeapVector<std::pair<String, Member<V8UnionUSVStringOrUSVStringSequence>>> member_accept_;
String member_description_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_PICKER_ACCEPT_TYPE_H_
