// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FACE_DETECTOR_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FACE_DETECTOR_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT FaceDetectorOptions : public bindings::InputDictionaryBase {
  
  public:
static FaceDetectorOptions* Create() {
  return MakeGarbageCollected<FaceDetectorOptions>();
}
static FaceDetectorOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FaceDetectorOptions>(isolate);
}
static FaceDetectorOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FaceDetectorOptions();
explicit  FaceDetectorOptions(v8::Isolate* isolate);

bool hasFastMode() const {
  return true;
}
bool fastMode() const {
  return member_fast_mode_;
}
void setFastMode(bool value) {
  member_fast_mode_ = value;
}

bool hasMaxDetectedFaces() const {
  return true;
}
uint16_t maxDetectedFaces() const {
  return member_max_detected_faces_;
}
void setMaxDetectedFaces(uint16_t value) {
  member_max_detected_faces_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_fast_mode_{false};
uint16_t member_max_detected_faces_{10};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FACE_DETECTOR_OPTIONS_H_
