// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_EXTENDABLE_COOKIE_CHANGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_EXTENDABLE_COOKIE_CHANGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class CookieListItem;
class ExceptionState;

class MODULES_EXPORT ExtendableCookieChangeEventInit : public ExtendableEventInit {
  
  public:
static ExtendableCookieChangeEventInit* Create() {
  return MakeGarbageCollected<ExtendableCookieChangeEventInit>();
}
static ExtendableCookieChangeEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ExtendableCookieChangeEventInit>(isolate);
}
static ExtendableCookieChangeEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ExtendableCookieChangeEventInit();
explicit  ExtendableCookieChangeEventInit(v8::Isolate* isolate);

bool hasChanged() const {
  return has_changed_;
}
const HeapVector<Member<CookieListItem>>& changed() const {
  DCHECK(hasChanged());
return member_changed_;
}
HeapVector<Member<CookieListItem>> getChangedOr(const HeapVector<Member<CookieListItem>>& fallback_value) const;
HeapVector<Member<CookieListItem>> getChangedOr(HeapVector<Member<CookieListItem>>&& fallback_value) const;
void setChanged(const HeapVector<Member<CookieListItem>>& value);
void setChanged(HeapVector<Member<CookieListItem>>&& value);

bool hasDeleted() const {
  return has_deleted_;
}
const HeapVector<Member<CookieListItem>>& deleted() const {
  DCHECK(hasDeleted());
return member_deleted_;
}
HeapVector<Member<CookieListItem>> getDeletedOr(const HeapVector<Member<CookieListItem>>& fallback_value) const;
HeapVector<Member<CookieListItem>> getDeletedOr(HeapVector<Member<CookieListItem>>&& fallback_value) const;
void setDeleted(const HeapVector<Member<CookieListItem>>& value);
void setDeleted(HeapVector<Member<CookieListItem>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = ExtendableEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_changed_ = false;
bool has_deleted_ = false;

HeapVector<Member<CookieListItem>> member_changed_;
HeapVector<Member<CookieListItem>> member_deleted_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_EXTENDABLE_COOKIE_CHANGE_EVENT_INIT_H_
