// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_encoded_video_chunk_metadata.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_svc_output_metadata.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_decoder_config.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"decoderConfig",
"svc",
};


}  // namespace 

EncodedVideoChunkMetadata* EncodedVideoChunkMetadata::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  EncodedVideoChunkMetadata* dictionary = MakeGarbageCollected<EncodedVideoChunkMetadata>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "EncodedVideoChunkMetadata";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 EncodedVideoChunkMetadata::EncodedVideoChunkMetadata() {
  
}

 EncodedVideoChunkMetadata::EncodedVideoChunkMetadata(v8::Isolate* isolate) {
  
}

















void EncodedVideoChunkMetadata::Trace(Visitor* visitor) const {
  visitor->Trace(member_decoder_config_);
visitor->Trace(member_svc_);
bindings::DictionaryBase::Trace(visitor);
}

void EncodedVideoChunkMetadata::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void EncodedVideoChunkMetadata::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasDecoderConfig()) {
  values[0] = ToV8Traits<VideoDecoderConfig>::ToV8(script_state, member_decoder_config_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasSvc()) {
  values[1] = ToV8Traits<SvcOutputMetadata>::ToV8(script_state, member_svc_.Get());
DCHECK(!values[1].IsEmpty());
}
}

const void* EncodedVideoChunkMetadata::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> EncodedVideoChunkMetadata::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void EncodedVideoChunkMetadata::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "EncodedVideoChunkMetadata";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("decoderConfig");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<VideoDecoderConfig, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_decoder_config_, member_decoder_config_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("svc");
if (!bindings::GetDictionaryMemberFromV8Object<SvcOutputMetadata, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_svc_, member_svc_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> EncodedVideoChunkMetadata::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
