// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DOCUMENT_PICTURE_IN_PICTURE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DOCUMENT_PICTURE_IN_PICTURE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT DocumentPictureInPictureOptions : public bindings::InputDictionaryBase {
  
  public:
static DocumentPictureInPictureOptions* Create() {
  return MakeGarbageCollected<DocumentPictureInPictureOptions>();
}
static DocumentPictureInPictureOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<DocumentPictureInPictureOptions>(isolate);
}
static DocumentPictureInPictureOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  DocumentPictureInPictureOptions();
explicit  DocumentPictureInPictureOptions(v8::Isolate* isolate);

bool hasDisallowReturnToOpener() const {
  return true;
}
bool disallowReturnToOpener() const {
  return member_disallow_return_to_opener_;
}
void setDisallowReturnToOpener(bool value) {
  member_disallow_return_to_opener_ = value;
}

bool hasHeight() const {
  return true;
}
uint64_t height() const {
  return member_height_;
}
void setHeight(uint64_t value) {
  member_height_ = value;
}

bool hasPreferInitialWindowPlacement() const {
  return true;
}
bool preferInitialWindowPlacement() const {
  return member_prefer_initial_window_placement_;
}
void setPreferInitialWindowPlacement(bool value) {
  member_prefer_initial_window_placement_ = value;
}

bool hasWidth() const {
  return true;
}
uint64_t width() const {
  return member_width_;
}
void setWidth(uint64_t value) {
  member_width_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_disallow_return_to_opener_{false};
uint64_t member_height_{0};
bool member_prefer_initial_window_placement_{false};
uint64_t member_width_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DOCUMENT_PICTURE_IN_PICTURE_OPTIONS_H_
