// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DECRYPT_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DECRYPT_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class EncryptionPattern;
class ExceptionState;
class SubsampleEntry;
class V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared;

class MODULES_EXPORT DecryptConfig : public bindings::InputDictionaryBase {
  
  public:
static DecryptConfig* Create() {
  return MakeGarbageCollected<DecryptConfig>();
}
static DecryptConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<DecryptConfig>(isolate);
}
static DecryptConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  DecryptConfig();
explicit  DecryptConfig(v8::Isolate* isolate);

bool hasEncryptionPattern() const {
  return has_encryption_pattern_;
}
EncryptionPattern* encryptionPattern() const {
  DCHECK(hasEncryptionPattern());
return member_encryption_pattern_.Get();
}
EncryptionPattern* getEncryptionPatternOr(EncryptionPattern* fallback_value) const {
  if (!hasEncryptionPattern()) {
  return fallback_value;
}
return member_encryption_pattern_.Get();
}
void setEncryptionPattern(EncryptionPattern* value) {
  member_encryption_pattern_ = value;
has_encryption_pattern_ = true;
DCHECK(member_encryption_pattern_);
}

bool hasEncryptionScheme() const {
  return true;
}
const String& encryptionScheme() const {
  return member_encryption_scheme_;
}
void setEncryptionScheme(const String& value);
void setEncryptionScheme(String&& value);

bool hasInitializationVector() const {
  return true;
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* initializationVector() const {
  return member_initialization_vector_.Get();
}
void setInitializationVector(V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* value) {
  member_initialization_vector_ = value;
DCHECK(member_initialization_vector_);
}

bool hasKeyId() const {
  return true;
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* keyId() const {
  return member_key_id_.Get();
}
void setKeyId(V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* value) {
  member_key_id_ = value;
DCHECK(member_key_id_);
}

bool hasSubsampleLayout() const {
  return true;
}
const HeapVector<Member<SubsampleEntry>>& subsampleLayout() const {
  return member_subsample_layout_;
}
void setSubsampleLayout(const HeapVector<Member<SubsampleEntry>>& value);
void setSubsampleLayout(HeapVector<Member<SubsampleEntry>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_encryption_pattern_ = false;

Member<EncryptionPattern> member_encryption_pattern_;
String member_encryption_scheme_;
Member<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared> member_initialization_vector_;
Member<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared> member_key_id_;
HeapVector<Member<SubsampleEntry>> member_subsample_layout_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_DECRYPT_CONFIG_H_
