// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_credential_request_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_digital_credential_request_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_federated_credential_request_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_credential_request_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_otp_credential_request_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_request_options.h"
#include "third_party/blink/renderer/core/dom/abort_signal.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"digital",
"federated",
"identity",
"mediation",
"otp",
"password",
"publicKey",
"signal",
};


}  // namespace 

CredentialRequestOptions* CredentialRequestOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  CredentialRequestOptions* dictionary = MakeGarbageCollected<CredentialRequestOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "CredentialRequestOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 CredentialRequestOptions::CredentialRequestOptions() {
  
}

 CredentialRequestOptions::CredentialRequestOptions(v8::Isolate* isolate) {
  
}























































void CredentialRequestOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_digital_);
visitor->Trace(member_federated_);
visitor->Trace(member_identity_);
visitor->Trace(member_otp_);
visitor->Trace(member_public_key_);
visitor->Trace(member_signal_);
bindings::InputDictionaryBase::Trace(visitor);
}

void CredentialRequestOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "CredentialRequestOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (RuntimeEnabledFeatures::WebIdentityDigitalCredentialsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("digital");
if (!bindings::GetDictionaryMemberFromV8Object<DigitalCredentialRequestOptions, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_digital_, member_digital_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("federated");
if (!bindings::GetDictionaryMemberFromV8Object<FederatedCredentialRequestOptions, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_federated_, member_federated_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("identity");
if (!bindings::GetDictionaryMemberFromV8Object<IdentityCredentialRequestOptions, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_identity_, member_identity_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediation");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8CredentialMediationRequirement, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_mediation_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebOTPEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("otp");
if (!bindings::GetDictionaryMemberFromV8Object<OTPCredentialRequestOptions, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_otp_, member_otp_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("password");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_password_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("publicKey");
if (!bindings::GetDictionaryMemberFromV8Object<PublicKeyCredentialRequestOptions, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_public_key_, member_public_key_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("signal");
if (!bindings::GetDictionaryMemberFromV8Object<AbortSignal, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_signal_, member_signal_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> CredentialRequestOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
