// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_constrain_point_2d_parameters.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_point_2d.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"exact",
"ideal",
};


}  // namespace 

ConstrainPoint2DParameters* ConstrainPoint2DParameters::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ConstrainPoint2DParameters* dictionary = MakeGarbageCollected<ConstrainPoint2DParameters>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ConstrainPoint2DParameters";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ConstrainPoint2DParameters::ConstrainPoint2DParameters() {
  
}

 ConstrainPoint2DParameters::ConstrainPoint2DParameters(v8::Isolate* isolate) {
  
}



HeapVector<Member<Point2D>> ConstrainPoint2DParameters::getExactOr(const HeapVector<Member<Point2D>>& fallback_value) const {
  if (!hasExact()) {
  return fallback_value;
}
return member_exact_;
}

HeapVector<Member<Point2D>> ConstrainPoint2DParameters::getExactOr(HeapVector<Member<Point2D>>&& fallback_value) const {
  if (!hasExact()) {
  return std::move(fallback_value);
}
return member_exact_;
}

void ConstrainPoint2DParameters::setExact(const HeapVector<Member<Point2D>>& value) {
  member_exact_ = value;
has_exact_ = true;
}

void ConstrainPoint2DParameters::setExact(HeapVector<Member<Point2D>>&& value) {
  member_exact_ = std::move(value);
has_exact_ = true;
}




HeapVector<Member<Point2D>> ConstrainPoint2DParameters::getIdealOr(const HeapVector<Member<Point2D>>& fallback_value) const {
  if (!hasIdeal()) {
  return fallback_value;
}
return member_ideal_;
}

HeapVector<Member<Point2D>> ConstrainPoint2DParameters::getIdealOr(HeapVector<Member<Point2D>>&& fallback_value) const {
  if (!hasIdeal()) {
  return std::move(fallback_value);
}
return member_ideal_;
}

void ConstrainPoint2DParameters::setIdeal(const HeapVector<Member<Point2D>>& value) {
  member_ideal_ = value;
has_ideal_ = true;
}

void ConstrainPoint2DParameters::setIdeal(HeapVector<Member<Point2D>>&& value) {
  member_ideal_ = std::move(value);
has_ideal_ = true;
}




void ConstrainPoint2DParameters::Trace(Visitor* visitor) const {
  visitor->Trace(member_exact_);
visitor->Trace(member_ideal_);
bindings::DictionaryBase::Trace(visitor);
}

void ConstrainPoint2DParameters::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void ConstrainPoint2DParameters::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasExact()) {
  values[0] = ToV8Traits<IDLSequence<Point2D>>::ToV8(script_state, member_exact_);
DCHECK(!values[0].IsEmpty());
}
if (hasIdeal()) {
  values[1] = ToV8Traits<IDLSequence<Point2D>>::ToV8(script_state, member_ideal_);
DCHECK(!values[1].IsEmpty());
}
}

const void* ConstrainPoint2DParameters::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> ConstrainPoint2DParameters::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void ConstrainPoint2DParameters::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ConstrainPoint2DParameters";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("exact");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<Point2D>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_exact_, member_exact_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("ideal");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<Point2D>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_ideal_, member_ideal_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ConstrainPoint2DParameters::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
