// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CONSTRAIN_DOUBLE_RANGE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CONSTRAIN_DOUBLE_RANGE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_double_range.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT ConstrainDoubleRange : public DoubleRange {
  
  public:
static ConstrainDoubleRange* Create() {
  return MakeGarbageCollected<ConstrainDoubleRange>();
}
static ConstrainDoubleRange* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ConstrainDoubleRange>(isolate);
}
static ConstrainDoubleRange* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ConstrainDoubleRange();
explicit  ConstrainDoubleRange(v8::Isolate* isolate);

bool hasExact() const {
  return has_exact_;
}
double exact() const {
  DCHECK(hasExact());
return member_exact_;
}
double getExactOr(double fallback_value) const {
  if (!hasExact()) {
  return fallback_value;
}
return member_exact_;
}
void setExact(double value) {
  member_exact_ = value;
has_exact_ = true;
}

bool hasIdeal() const {
  return has_ideal_;
}
double ideal() const {
  DCHECK(hasIdeal());
return member_ideal_;
}
double getIdealOr(double fallback_value) const {
  if (!hasIdeal()) {
  return fallback_value;
}
return member_ideal_;
}
void setIdeal(double value) {
  member_ideal_ = value;
has_ideal_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = DoubleRange::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_exact_ = false;
bool has_ideal_ = false;

double member_exact_;
double member_ideal_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CONSTRAIN_DOUBLE_RANGE_H_
