// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_COLLECTED_CLIENT_DATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_COLLECTED_CLIENT_DATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT CollectedClientData : public bindings::DictionaryBase {
  
  public:
static CollectedClientData* Create() {
  return MakeGarbageCollected<CollectedClientData>();
}
static CollectedClientData* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CollectedClientData>(isolate);
}
static CollectedClientData* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CollectedClientData();
explicit  CollectedClientData(v8::Isolate* isolate);

bool hasChallenge() const {
  return true;
}
const String& challenge() const {
  return member_challenge_;
}
void setChallenge(const String& value);
void setChallenge(String&& value);

bool hasOrigin() const {
  return true;
}
const String& origin() const {
  return member_origin_;
}
void setOrigin(const String& value);
void setOrigin(String&& value);

bool hasTokenBindingId() const {
  return has_token_binding_id_;
}
const String& tokenBindingId() const {
  DCHECK(hasTokenBindingId());
return member_token_binding_id_;
}
String getTokenBindingIdOr(const String& fallback_value) const;
String getTokenBindingIdOr(String&& fallback_value) const;
void setTokenBindingId(const String& value);
void setTokenBindingId(String&& value);

bool hasType() const {
  return true;
}
const String& type() const {
  return member_type_;
}
void setType(const String& value);
void setType(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_token_binding_id_ = false;

String member_challenge_;
String member_origin_;
String member_token_binding_id_;
String member_type_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_COLLECTED_CLIENT_DATA_H_
