// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLIPBOARD_PERMISSION_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLIPBOARD_PERMISSION_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_permission_descriptor.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT ClipboardPermissionDescriptor : public PermissionDescriptor {
  
  public:
static ClipboardPermissionDescriptor* Create() {
  return MakeGarbageCollected<ClipboardPermissionDescriptor>();
}
static ClipboardPermissionDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ClipboardPermissionDescriptor>(isolate);
}
static ClipboardPermissionDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ClipboardPermissionDescriptor();
explicit  ClipboardPermissionDescriptor(v8::Isolate* isolate);

bool hasAllowWithoutGesture() const {
  return true;
}
bool allowWithoutGesture() const {
  return member_allow_without_gesture_;
}
void setAllowWithoutGesture(bool value) {
  member_allow_without_gesture_ = value;
}

bool hasAllowWithoutSanitization() const {
  return true;
}
bool allowWithoutSanitization() const {
  return member_allow_without_sanitization_;
}
void setAllowWithoutSanitization(bool value) {
  member_allow_without_sanitization_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = PermissionDescriptor::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_allow_without_gesture_{false};
bool member_allow_without_sanitization_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CLIPBOARD_PERMISSION_DESCRIPTOR_H_
