// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CANVAS_RENDERING_CONTEXT_2D_SETTINGS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CANVAS_RENDERING_CONTEXT_2D_SETTINGS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_predefined_color_space.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_pixel_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT CanvasRenderingContext2DSettings : public bindings::DictionaryBase {
  
  public:
static CanvasRenderingContext2DSettings* Create() {
  return MakeGarbageCollected<CanvasRenderingContext2DSettings>();
}
static CanvasRenderingContext2DSettings* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CanvasRenderingContext2DSettings>(isolate);
}
static CanvasRenderingContext2DSettings* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CanvasRenderingContext2DSettings();
explicit  CanvasRenderingContext2DSettings(v8::Isolate* isolate);

bool hasAlpha() const {
  return true;
}
bool alpha() const {
  return member_alpha_;
}
void setAlpha(bool value) {
  member_alpha_ = value;
}

bool hasColorSpace() const {
  return true;
}
V8PredefinedColorSpace colorSpace() const {
  return member_color_space_;
}
void setColorSpace(V8PredefinedColorSpace value) {
  member_color_space_ = value;
}
void setColorSpace(V8PredefinedColorSpace::Enum value) {
  member_color_space_ = V8PredefinedColorSpace(value);
}

bool hasColorType() const {
  return true;
}
V8CanvasPixelFormat colorType() const {
  return member_color_type_;
}
void setColorType(V8CanvasPixelFormat value) {
  member_color_type_ = value;
}
void setColorType(V8CanvasPixelFormat::Enum value) {
  member_color_type_ = V8CanvasPixelFormat(value);
}

bool hasDesynchronized() const {
  return true;
}
bool desynchronized() const {
  return member_desynchronized_;
}
void setDesynchronized(bool value) {
  member_desynchronized_ = value;
}

bool hasWillReadFrequently() const {
  return true;
}
bool willReadFrequently() const {
  return member_will_read_frequently_;
}
void setWillReadFrequently(bool value) {
  member_will_read_frequently_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_alpha_{true};
V8PredefinedColorSpace member_color_space_{V8PredefinedColorSpace::Enum::kSRGB};
V8CanvasPixelFormat member_color_type_{V8CanvasPixelFormat::Enum::kUnorm8};
bool member_desynchronized_{false};
bool member_will_read_frequently_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CANVAS_RENDERING_CONTEXT_2D_SETTINGS_H_
