// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CACHE_QUERY_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CACHE_QUERY_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT CacheQueryOptions : public bindings::InputDictionaryBase {
  
  public:
static CacheQueryOptions* Create() {
  return MakeGarbageCollected<CacheQueryOptions>();
}
static CacheQueryOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CacheQueryOptions>(isolate);
}
static CacheQueryOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CacheQueryOptions();
explicit  CacheQueryOptions(v8::Isolate* isolate);

bool hasIgnoreMethod() const {
  return true;
}
bool ignoreMethod() const {
  return member_ignore_method_;
}
void setIgnoreMethod(bool value) {
  member_ignore_method_ = value;
}

bool hasIgnoreSearch() const {
  return true;
}
bool ignoreSearch() const {
  return member_ignore_search_;
}
void setIgnoreSearch(bool value) {
  member_ignore_search_ = value;
}

bool hasIgnoreVary() const {
  return true;
}
bool ignoreVary() const {
  return member_ignore_vary_;
}
void setIgnoreVary(bool value) {
  member_ignore_vary_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_ignore_method_{false};
bool member_ignore_search_{false};
bool member_ignore_vary_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_CACHE_QUERY_OPTIONS_H_
