// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BROWSING_TOPIC_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BROWSING_TOPIC_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT BrowsingTopic : public bindings::DictionaryBase {
  
  public:
static BrowsingTopic* Create() {
  return MakeGarbageCollected<BrowsingTopic>();
}
static BrowsingTopic* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BrowsingTopic>(isolate);
}
static BrowsingTopic* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BrowsingTopic();
explicit  BrowsingTopic(v8::Isolate* isolate);

bool hasConfigVersion() const {
  return has_config_version_;
}
const String& configVersion() const {
  DCHECK(hasConfigVersion());
return member_config_version_;
}
String getConfigVersionOr(const String& fallback_value) const;
String getConfigVersionOr(String&& fallback_value) const;
void setConfigVersion(const String& value);
void setConfigVersion(String&& value);

bool hasModelVersion() const {
  return has_model_version_;
}
const String& modelVersion() const {
  DCHECK(hasModelVersion());
return member_model_version_;
}
String getModelVersionOr(const String& fallback_value) const;
String getModelVersionOr(String&& fallback_value) const;
void setModelVersion(const String& value);
void setModelVersion(String&& value);

bool hasTaxonomyVersion() const {
  return has_taxonomy_version_;
}
const String& taxonomyVersion() const {
  DCHECK(hasTaxonomyVersion());
return member_taxonomy_version_;
}
String getTaxonomyVersionOr(const String& fallback_value) const;
String getTaxonomyVersionOr(String&& fallback_value) const;
void setTaxonomyVersion(const String& value);
void setTaxonomyVersion(String&& value);

bool hasTopic() const {
  return has_topic_;
}
int32_t topic() const {
  DCHECK(hasTopic());
return member_topic_;
}
int32_t getTopicOr(int32_t fallback_value) const {
  if (!hasTopic()) {
  return fallback_value;
}
return member_topic_;
}
void setTopic(int32_t value) {
  member_topic_ = value;
has_topic_ = true;
}

bool hasVersion() const {
  return has_version_;
}
const String& version() const {
  DCHECK(hasVersion());
return member_version_;
}
String getVersionOr(const String& fallback_value) const;
String getVersionOr(String&& fallback_value) const;
void setVersion(const String& value);
void setVersion(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_config_version_ = false;
bool has_model_version_ = false;
bool has_taxonomy_version_ = false;
bool has_topic_ = false;
bool has_version_ = false;

String member_config_version_;
String member_model_version_;
String member_taxonomy_version_;
int32_t member_topic_;
String member_version_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BROWSING_TOPIC_H_
