// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLUETOOTH_DATA_FILTER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLUETOOTH_DATA_FILTER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT BluetoothDataFilterInit : public bindings::DictionaryBase {
  
  public:
static BluetoothDataFilterInit* Create() {
  return MakeGarbageCollected<BluetoothDataFilterInit>();
}
static BluetoothDataFilterInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BluetoothDataFilterInit>(isolate);
}
static BluetoothDataFilterInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BluetoothDataFilterInit();
explicit  BluetoothDataFilterInit(v8::Isolate* isolate);

bool hasDataPrefix() const {
  return has_data_prefix_;
}
V8UnionArrayBufferOrArrayBufferView* dataPrefix() const {
  DCHECK(hasDataPrefix());
return member_data_prefix_.Get();
}
V8UnionArrayBufferOrArrayBufferView* getDataPrefixOr(V8UnionArrayBufferOrArrayBufferView* fallback_value) const {
  if (!hasDataPrefix()) {
  return fallback_value;
}
return member_data_prefix_.Get();
}
void setDataPrefix(V8UnionArrayBufferOrArrayBufferView* value) {
  member_data_prefix_ = value;
has_data_prefix_ = true;
DCHECK(member_data_prefix_);
}

bool hasMask() const {
  return has_mask_;
}
V8UnionArrayBufferOrArrayBufferView* mask() const {
  DCHECK(hasMask());
return member_mask_.Get();
}
V8UnionArrayBufferOrArrayBufferView* getMaskOr(V8UnionArrayBufferOrArrayBufferView* fallback_value) const {
  if (!hasMask()) {
  return fallback_value;
}
return member_mask_.Get();
}
void setMask(V8UnionArrayBufferOrArrayBufferView* value) {
  member_mask_ = value;
has_mask_ = true;
DCHECK(member_mask_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_data_prefix_ = false;
bool has_mask_ = false;

Member<V8UnionArrayBufferOrArrayBufferView> member_data_prefix_;
Member<V8UnionArrayBufferOrArrayBufferView> member_mask_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLUETOOTH_DATA_FILTER_INIT_H_
