// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLUETOOTH_ADVERTISING_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLUETOOTH_ADVERTISING_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class BluetoothDevice;
class BluetoothManufacturerDataMap;
class BluetoothServiceDataMap;
class ExceptionState;
class V8UnionStringOrUnsignedLong;

class MODULES_EXPORT BluetoothAdvertisingEventInit : public EventInit {
  
  public:
static BluetoothAdvertisingEventInit* Create() {
  return MakeGarbageCollected<BluetoothAdvertisingEventInit>();
}
static BluetoothAdvertisingEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BluetoothAdvertisingEventInit>(isolate);
}
static BluetoothAdvertisingEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BluetoothAdvertisingEventInit();
explicit  BluetoothAdvertisingEventInit(v8::Isolate* isolate);

bool hasAppearance() const {
  return has_appearance_;
}
uint16_t appearance() const {
  DCHECK(hasAppearance());
return member_appearance_;
}
uint16_t getAppearanceOr(uint16_t fallback_value) const {
  if (!hasAppearance()) {
  return fallback_value;
}
return member_appearance_;
}
void setAppearance(uint16_t value) {
  member_appearance_ = value;
has_appearance_ = true;
}

bool hasDevice() const {
  return true;
}
BluetoothDevice* device() const {
  return member_device_.Get();
}
void setDevice(BluetoothDevice* value) {
  member_device_ = value;
DCHECK(member_device_);
}

bool hasManufacturerData() const {
  return has_manufacturer_data_;
}
BluetoothManufacturerDataMap* manufacturerData() const {
  DCHECK(hasManufacturerData());
return member_manufacturer_data_.Get();
}
BluetoothManufacturerDataMap* getManufacturerDataOr(BluetoothManufacturerDataMap* fallback_value) const {
  if (!hasManufacturerData()) {
  return fallback_value;
}
return member_manufacturer_data_.Get();
}
void setManufacturerData(BluetoothManufacturerDataMap* value) {
  member_manufacturer_data_ = value;
has_manufacturer_data_ = true;
DCHECK(member_manufacturer_data_);
}

bool hasName() const {
  return has_name_;
}
const String& name() const {
  DCHECK(hasName());
return member_name_;
}
String getNameOr(const String& fallback_value) const;
String getNameOr(String&& fallback_value) const;
void setName(const String& value);
void setName(String&& value);

bool hasRssi() const {
  return has_rssi_;
}
int8_t rssi() const {
  DCHECK(hasRssi());
return member_rssi_;
}
int8_t getRssiOr(int8_t fallback_value) const {
  if (!hasRssi()) {
  return fallback_value;
}
return member_rssi_;
}
void setRssi(int8_t value) {
  member_rssi_ = value;
has_rssi_ = true;
}

bool hasServiceData() const {
  return has_service_data_;
}
BluetoothServiceDataMap* serviceData() const {
  DCHECK(hasServiceData());
return member_service_data_.Get();
}
BluetoothServiceDataMap* getServiceDataOr(BluetoothServiceDataMap* fallback_value) const {
  if (!hasServiceData()) {
  return fallback_value;
}
return member_service_data_.Get();
}
void setServiceData(BluetoothServiceDataMap* value) {
  member_service_data_ = value;
has_service_data_ = true;
DCHECK(member_service_data_);
}

bool hasTxPower() const {
  return has_tx_power_;
}
int8_t txPower() const {
  DCHECK(hasTxPower());
return member_tx_power_;
}
int8_t getTxPowerOr(int8_t fallback_value) const {
  if (!hasTxPower()) {
  return fallback_value;
}
return member_tx_power_;
}
void setTxPower(int8_t value) {
  member_tx_power_ = value;
has_tx_power_ = true;
}

bool hasUuids() const {
  return has_uuids_;
}
const HeapVector<Member<V8UnionStringOrUnsignedLong>>& uuids() const {
  DCHECK(hasUuids());
return member_uuids_;
}
HeapVector<Member<V8UnionStringOrUnsignedLong>> getUuidsOr(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& fallback_value) const;
HeapVector<Member<V8UnionStringOrUnsignedLong>> getUuidsOr(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& fallback_value) const;
void setUuids(const HeapVector<Member<V8UnionStringOrUnsignedLong>>& value);
void setUuids(HeapVector<Member<V8UnionStringOrUnsignedLong>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_appearance_ = false;
bool has_manufacturer_data_ = false;
bool has_name_ = false;
bool has_rssi_ = false;
bool has_service_data_ = false;
bool has_tx_power_ = false;
bool has_uuids_ = false;

uint16_t member_appearance_;
Member<BluetoothDevice> member_device_;
Member<BluetoothManufacturerDataMap> member_manufacturer_data_;
String member_name_;
int8_t member_rssi_;
Member<BluetoothServiceDataMap> member_service_data_;
int8_t member_tx_power_;
HeapVector<Member<V8UnionStringOrUnsignedLong>> member_uuids_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BLUETOOTH_ADVERTISING_EVENT_INIT_H_
