// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BIQUAD_FILTER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BIQUAD_FILTER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_node_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_biquad_filter_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT BiquadFilterOptions : public AudioNodeOptions {
  
  public:
static BiquadFilterOptions* Create() {
  return MakeGarbageCollected<BiquadFilterOptions>();
}
static BiquadFilterOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BiquadFilterOptions>(isolate);
}
static BiquadFilterOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BiquadFilterOptions();
explicit  BiquadFilterOptions(v8::Isolate* isolate);

bool hasQ() const {
  return true;
}
float q() const {
  return member_q_;
}
void setQ(float value) {
  member_q_ = value;
}

bool hasDetune() const {
  return true;
}
float detune() const {
  return member_detune_;
}
void setDetune(float value) {
  member_detune_ = value;
}

bool hasFrequency() const {
  return true;
}
float frequency() const {
  return member_frequency_;
}
void setFrequency(float value) {
  member_frequency_ = value;
}

bool hasGain() const {
  return true;
}
float gain() const {
  return member_gain_;
}
void setGain(float value) {
  member_gain_ = value;
}

bool hasType() const {
  return true;
}
V8BiquadFilterType type() const {
  return member_type_;
}
void setType(V8BiquadFilterType value) {
  member_type_ = value;
}
void setType(V8BiquadFilterType::Enum value) {
  member_type_ = V8BiquadFilterType(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = AudioNodeOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



float member_q_{1};
float member_detune_{0};
float member_frequency_{350};
float member_gain_{0};
V8BiquadFilterType member_type_{V8BiquadFilterType::Enum::kLowpass};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BIQUAD_FILTER_OPTIONS_H_
