// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BARCODE_DETECTOR_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BARCODE_DETECTOR_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_barcode_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT BarcodeDetectorOptions : public bindings::InputDictionaryBase {
  
  public:
static BarcodeDetectorOptions* Create() {
  return MakeGarbageCollected<BarcodeDetectorOptions>();
}
static BarcodeDetectorOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BarcodeDetectorOptions>(isolate);
}
static BarcodeDetectorOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BarcodeDetectorOptions();
explicit  BarcodeDetectorOptions(v8::Isolate* isolate);

bool hasFormats() const {
  return has_formats_;
}
const Vector<V8BarcodeFormat>& formats() const {
  DCHECK(hasFormats());
return member_formats_;
}
Vector<V8BarcodeFormat> getFormatsOr(const Vector<V8BarcodeFormat>& fallback_value) const;
Vector<V8BarcodeFormat> getFormatsOr(Vector<V8BarcodeFormat>&& fallback_value) const;
void setFormats(const Vector<V8BarcodeFormat>& value);
void setFormats(Vector<V8BarcodeFormat>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_formats_ = false;

Vector<V8BarcodeFormat> member_formats_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_BARCODE_DETECTOR_OPTIONS_H_
