// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATOR_ASSERTION_RESPONSE_JS_ON_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATOR_ASSERTION_RESPONSE_JS_ON_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AuthenticatorAssertionResponseJSON : public bindings::DictionaryBase {
  
  public:
static AuthenticatorAssertionResponseJSON* Create() {
  return MakeGarbageCollected<AuthenticatorAssertionResponseJSON>();
}
static AuthenticatorAssertionResponseJSON* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticatorAssertionResponseJSON>(isolate);
}
static AuthenticatorAssertionResponseJSON* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticatorAssertionResponseJSON();
explicit  AuthenticatorAssertionResponseJSON(v8::Isolate* isolate);

bool hasAuthenticatorData() const {
  return true;
}
const String& authenticatorData() const {
  return member_authenticator_data_;
}
void setAuthenticatorData(const String& value);
void setAuthenticatorData(String&& value);

bool hasClientDataJSON() const {
  return true;
}
const String& clientDataJSON() const {
  return member_client_data_js_on_;
}
void setClientDataJSON(const String& value);
void setClientDataJSON(String&& value);

bool hasSignature() const {
  return true;
}
const String& signature() const {
  return member_signature_;
}
void setSignature(const String& value);
void setSignature(String&& value);

bool hasUserHandle() const {
  return has_user_handle_;
}
const String& userHandle() const {
  DCHECK(hasUserHandle());
return member_user_handle_;
}
String getUserHandleOr(const String& fallback_value) const;
String getUserHandleOr(String&& fallback_value) const;
void setUserHandle(const String& value);
void setUserHandle(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_user_handle_ = false;

String member_authenticator_data_;
String member_client_data_js_on_;
String member_signature_;
String member_user_handle_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATOR_ASSERTION_RESPONSE_JS_ON_H_
