// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_prf_values_js_on.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"first",
"second",
};


}  // namespace 

AuthenticationExtensionsPRFValuesJSON* AuthenticationExtensionsPRFValuesJSON::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuthenticationExtensionsPRFValuesJSON* dictionary = MakeGarbageCollected<AuthenticationExtensionsPRFValuesJSON>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuthenticationExtensionsPRFValuesJSON";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuthenticationExtensionsPRFValuesJSON::AuthenticationExtensionsPRFValuesJSON() {
  
}

 AuthenticationExtensionsPRFValuesJSON::AuthenticationExtensionsPRFValuesJSON(v8::Isolate* isolate) {
  
}



void AuthenticationExtensionsPRFValuesJSON::setFirst(const String& value) {
  member_first_ = value;
}

void AuthenticationExtensionsPRFValuesJSON::setFirst(String&& value) {
  member_first_ = std::move(value);
}




String AuthenticationExtensionsPRFValuesJSON::getSecondOr(const String& fallback_value) const {
  if (!hasSecond()) {
  return fallback_value;
}
return member_second_;
}

String AuthenticationExtensionsPRFValuesJSON::getSecondOr(String&& fallback_value) const {
  if (!hasSecond()) {
  return std::move(fallback_value);
}
return member_second_;
}

void AuthenticationExtensionsPRFValuesJSON::setSecond(const String& value) {
  member_second_ = value;
has_second_ = true;
}

void AuthenticationExtensionsPRFValuesJSON::setSecond(String&& value) {
  member_second_ = std::move(value);
has_second_ = true;
}




void AuthenticationExtensionsPRFValuesJSON::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void AuthenticationExtensionsPRFValuesJSON::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuthenticationExtensionsPRFValuesJSON";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("first");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_first_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("second");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_second_, member_second_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuthenticationExtensionsPRFValuesJSON::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
