// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_prf_inputs_js_on.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_prf_values_js_on.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"eval",
"evalByCredential",
};


}  // namespace 

AuthenticationExtensionsPRFInputsJSON* AuthenticationExtensionsPRFInputsJSON::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuthenticationExtensionsPRFInputsJSON* dictionary = MakeGarbageCollected<AuthenticationExtensionsPRFInputsJSON>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuthenticationExtensionsPRFInputsJSON";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuthenticationExtensionsPRFInputsJSON::AuthenticationExtensionsPRFInputsJSON() {
  
}

 AuthenticationExtensionsPRFInputsJSON::AuthenticationExtensionsPRFInputsJSON(v8::Isolate* isolate) {
  
}










HeapVector<std::pair<String, Member<AuthenticationExtensionsPRFValuesJSON>>> AuthenticationExtensionsPRFInputsJSON::getEvalByCredentialOr(const HeapVector<std::pair<String, Member<AuthenticationExtensionsPRFValuesJSON>>>& fallback_value) const {
  if (!hasEvalByCredential()) {
  return fallback_value;
}
return member_eval_by_credential_;
}

HeapVector<std::pair<String, Member<AuthenticationExtensionsPRFValuesJSON>>> AuthenticationExtensionsPRFInputsJSON::getEvalByCredentialOr(HeapVector<std::pair<String, Member<AuthenticationExtensionsPRFValuesJSON>>>&& fallback_value) const {
  if (!hasEvalByCredential()) {
  return std::move(fallback_value);
}
return member_eval_by_credential_;
}

void AuthenticationExtensionsPRFInputsJSON::setEvalByCredential(const HeapVector<std::pair<String, Member<AuthenticationExtensionsPRFValuesJSON>>>& value) {
  member_eval_by_credential_ = value;
has_eval_by_credential_ = true;
}

void AuthenticationExtensionsPRFInputsJSON::setEvalByCredential(HeapVector<std::pair<String, Member<AuthenticationExtensionsPRFValuesJSON>>>&& value) {
  member_eval_by_credential_ = std::move(value);
has_eval_by_credential_ = true;
}




void AuthenticationExtensionsPRFInputsJSON::Trace(Visitor* visitor) const {
  visitor->Trace(member_eval_);
visitor->Trace(member_eval_by_credential_);
bindings::InputDictionaryBase::Trace(visitor);
}

void AuthenticationExtensionsPRFInputsJSON::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuthenticationExtensionsPRFInputsJSON";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("eval");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsPRFValuesJSON, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_eval_, member_eval_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("evalByCredential");
if (!bindings::GetDictionaryMemberFromV8Object<IDLRecord<IDLUSVString, AuthenticationExtensionsPRFValuesJSON>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_eval_by_credential_, member_eval_by_credential_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuthenticationExtensionsPRFInputsJSON::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
