// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_large_blob_inputs_js_on.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"read",
"support",
"write",
};


}  // namespace 

AuthenticationExtensionsLargeBlobInputsJSON* AuthenticationExtensionsLargeBlobInputsJSON::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AuthenticationExtensionsLargeBlobInputsJSON* dictionary = MakeGarbageCollected<AuthenticationExtensionsLargeBlobInputsJSON>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AuthenticationExtensionsLargeBlobInputsJSON";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AuthenticationExtensionsLargeBlobInputsJSON::AuthenticationExtensionsLargeBlobInputsJSON() {
  
}

 AuthenticationExtensionsLargeBlobInputsJSON::AuthenticationExtensionsLargeBlobInputsJSON(v8::Isolate* isolate) {
  
}










String AuthenticationExtensionsLargeBlobInputsJSON::getSupportOr(const String& fallback_value) const {
  if (!hasSupport()) {
  return fallback_value;
}
return member_support_;
}

String AuthenticationExtensionsLargeBlobInputsJSON::getSupportOr(String&& fallback_value) const {
  if (!hasSupport()) {
  return std::move(fallback_value);
}
return member_support_;
}

void AuthenticationExtensionsLargeBlobInputsJSON::setSupport(const String& value) {
  member_support_ = value;
has_support_ = true;
}

void AuthenticationExtensionsLargeBlobInputsJSON::setSupport(String&& value) {
  member_support_ = std::move(value);
has_support_ = true;
}




String AuthenticationExtensionsLargeBlobInputsJSON::getWriteOr(const String& fallback_value) const {
  if (!hasWrite()) {
  return fallback_value;
}
return member_write_;
}

String AuthenticationExtensionsLargeBlobInputsJSON::getWriteOr(String&& fallback_value) const {
  if (!hasWrite()) {
  return std::move(fallback_value);
}
return member_write_;
}

void AuthenticationExtensionsLargeBlobInputsJSON::setWrite(const String& value) {
  member_write_ = value;
has_write_ = true;
}

void AuthenticationExtensionsLargeBlobInputsJSON::setWrite(String&& value) {
  member_write_ = std::move(value);
has_write_ = true;
}




void AuthenticationExtensionsLargeBlobInputsJSON::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void AuthenticationExtensionsLargeBlobInputsJSON::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AuthenticationExtensionsLargeBlobInputsJSON";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("read");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_read_, member_read_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("support");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_support_, member_support_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("write");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_write_, member_write_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AuthenticationExtensionsLargeBlobInputsJSON::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
