// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_CLIENT_OUTPUTS_JS_ON_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_CLIENT_OUTPUTS_JS_ON_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class CredentialPropertiesOutput;
class ExceptionState;

class MODULES_EXPORT AuthenticationExtensionsClientOutputsJSON : public bindings::DictionaryBase {
  
  public:
static AuthenticationExtensionsClientOutputsJSON* Create() {
  return MakeGarbageCollected<AuthenticationExtensionsClientOutputsJSON>();
}
static AuthenticationExtensionsClientOutputsJSON* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticationExtensionsClientOutputsJSON>(isolate);
}
static AuthenticationExtensionsClientOutputsJSON* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticationExtensionsClientOutputsJSON();
explicit  AuthenticationExtensionsClientOutputsJSON(v8::Isolate* isolate);

bool hasAppid() const {
  return has_appid_;
}
bool appid() const {
  DCHECK(hasAppid());
return member_appid_;
}
bool getAppidOr(bool fallback_value) const {
  if (!hasAppid()) {
  return fallback_value;
}
return member_appid_;
}
void setAppid(bool value) {
  member_appid_ = value;
has_appid_ = true;
}

bool hasCredBlob() const {
  return has_cred_blob_;
}
bool credBlob() const {
  DCHECK(hasCredBlob());
return member_cred_blob_;
}
bool getCredBlobOr(bool fallback_value) const {
  if (!hasCredBlob()) {
  return fallback_value;
}
return member_cred_blob_;
}
void setCredBlob(bool value) {
  member_cred_blob_ = value;
has_cred_blob_ = true;
}

bool hasCredProps() const {
  return has_cred_props_;
}
CredentialPropertiesOutput* credProps() const {
  DCHECK(hasCredProps());
return member_cred_props_.Get();
}
CredentialPropertiesOutput* getCredPropsOr(CredentialPropertiesOutput* fallback_value) const {
  if (!hasCredProps()) {
  return fallback_value;
}
return member_cred_props_.Get();
}
void setCredProps(CredentialPropertiesOutput* value) {
  member_cred_props_ = value;
has_cred_props_ = true;
DCHECK(member_cred_props_);
}

bool hasGetCredBlob() const {
  return has_get_cred_blob_;
}
const String& getCredBlob() const {
  DCHECK(hasGetCredBlob());
return member_get_cred_blob_;
}
String getGetCredBlobOr(const String& fallback_value) const;
String getGetCredBlobOr(String&& fallback_value) const;
void setGetCredBlob(const String& value);
void setGetCredBlob(String&& value);

bool hasHmacCreateSecret() const {
  return has_hmac_create_secret_;
}
bool hmacCreateSecret() const {
  DCHECK(hasHmacCreateSecret());
return member_hmac_create_secret_;
}
bool getHmacCreateSecretOr(bool fallback_value) const {
  if (!hasHmacCreateSecret()) {
  return fallback_value;
}
return member_hmac_create_secret_;
}
void setHmacCreateSecret(bool value) {
  member_hmac_create_secret_ = value;
has_hmac_create_secret_ = true;
}

bool hasLargeBlob() const {
  return has_large_blob_;
}
const ScriptObject& largeBlob() const {
  DCHECK(hasLargeBlob());
return member_large_blob_;
}
ScriptObject getLargeBlobOr(const ScriptObject& fallback_value) const {
  if (!hasLargeBlob()) {
  return fallback_value;
}
return member_large_blob_;
}
void setLargeBlob(const ScriptObject& value) {
  member_large_blob_ = value;
has_large_blob_ = true;
}

bool hasPrf() const {
  return has_prf_;
}
const ScriptObject& prf() const {
  DCHECK(hasPrf());
return member_prf_;
}
ScriptObject getPrfOr(const ScriptObject& fallback_value) const {
  if (!hasPrf()) {
  return fallback_value;
}
return member_prf_;
}
void setPrf(const ScriptObject& value) {
  member_prf_ = value;
has_prf_ = true;
}

bool hasSupplementalPubKeys() const {
  return has_supplemental_pub_keys_;
}
const ScriptObject& supplementalPubKeys() const {
  DCHECK(hasSupplementalPubKeys());
return member_supplemental_pub_keys_;
}
ScriptObject getSupplementalPubKeysOr(const ScriptObject& fallback_value) const {
  if (!hasSupplementalPubKeys()) {
  return fallback_value;
}
return member_supplemental_pub_keys_;
}
void setSupplementalPubKeys(const ScriptObject& value) {
  member_supplemental_pub_keys_ = value;
has_supplemental_pub_keys_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_appid_ = false;
bool has_cred_blob_ = false;
bool has_cred_props_ = false;
bool has_get_cred_blob_ = false;
bool has_hmac_create_secret_ = false;
bool has_large_blob_ = false;
bool has_prf_ = false;
bool has_supplemental_pub_keys_ = false;

bool member_appid_;
bool member_cred_blob_;
Member<CredentialPropertiesOutput> member_cred_props_;
String member_get_cred_blob_;
bool member_hmac_create_secret_;
ScriptObject member_large_blob_;
ScriptObject member_prf_;
ScriptObject member_supplemental_pub_keys_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_CLIENT_OUTPUTS_JS_ON_H_
