// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_CLIENT_INPUTS_JS_ON_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_CLIENT_INPUTS_JS_ON_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AuthenticationExtensionsLargeBlobInputsJSON;
class AuthenticationExtensionsPRFInputsJSON;
class AuthenticationExtensionsPaymentInputs;
class AuthenticationExtensionsSupplementalPubKeysInputs;
class ExceptionState;
class RemoteDesktopClientOverride;

class MODULES_EXPORT AuthenticationExtensionsClientInputsJSON : public bindings::InputDictionaryBase {
  
  public:
static AuthenticationExtensionsClientInputsJSON* Create() {
  return MakeGarbageCollected<AuthenticationExtensionsClientInputsJSON>();
}
static AuthenticationExtensionsClientInputsJSON* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuthenticationExtensionsClientInputsJSON>(isolate);
}
static AuthenticationExtensionsClientInputsJSON* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuthenticationExtensionsClientInputsJSON();
explicit  AuthenticationExtensionsClientInputsJSON(v8::Isolate* isolate);

bool hasAppid() const {
  return has_appid_;
}
const String& appid() const {
  DCHECK(hasAppid());
return member_appid_;
}
String getAppidOr(const String& fallback_value) const;
String getAppidOr(String&& fallback_value) const;
void setAppid(const String& value);
void setAppid(String&& value);

bool hasAppidExclude() const {
  return has_appid_exclude_;
}
const String& appidExclude() const {
  DCHECK(hasAppidExclude());
return member_appid_exclude_;
}
String getAppidExcludeOr(const String& fallback_value) const;
String getAppidExcludeOr(String&& fallback_value) const;
void setAppidExclude(const String& value);
void setAppidExclude(String&& value);

bool hasCredBlob() const {
  return has_cred_blob_;
}
const String& credBlob() const {
  DCHECK(hasCredBlob());
return member_cred_blob_;
}
String getCredBlobOr(const String& fallback_value) const;
String getCredBlobOr(String&& fallback_value) const;
void setCredBlob(const String& value);
void setCredBlob(String&& value);

bool hasCredProps() const {
  return true;
}
bool credProps() const {
  return member_cred_props_;
}
void setCredProps(bool value) {
  member_cred_props_ = value;
}

bool hasCredentialProtectionPolicy() const {
  return has_credential_protection_policy_;
}
const String& credentialProtectionPolicy() const {
  DCHECK(hasCredentialProtectionPolicy());
return member_credential_protection_policy_;
}
String getCredentialProtectionPolicyOr(const String& fallback_value) const;
String getCredentialProtectionPolicyOr(String&& fallback_value) const;
void setCredentialProtectionPolicy(const String& value);
void setCredentialProtectionPolicy(String&& value);

bool hasEnforceCredentialProtectionPolicy() const {
  return true;
}
bool enforceCredentialProtectionPolicy() const {
  return member_enforce_credential_protection_policy_;
}
void setEnforceCredentialProtectionPolicy(bool value) {
  member_enforce_credential_protection_policy_ = value;
}

bool hasGetCredBlob() const {
  return has_get_cred_blob_;
}
bool getCredBlob() const {
  DCHECK(hasGetCredBlob());
return member_get_cred_blob_;
}
bool getGetCredBlobOr(bool fallback_value) const {
  if (!hasGetCredBlob()) {
  return fallback_value;
}
return member_get_cred_blob_;
}
void setGetCredBlob(bool value) {
  member_get_cred_blob_ = value;
has_get_cred_blob_ = true;
}

bool hasHmacCreateSecret() const {
  return has_hmac_create_secret_;
}
bool hmacCreateSecret() const {
  DCHECK(hasHmacCreateSecret());
return member_hmac_create_secret_;
}
bool getHmacCreateSecretOr(bool fallback_value) const {
  if (!hasHmacCreateSecret()) {
  return fallback_value;
}
return member_hmac_create_secret_;
}
void setHmacCreateSecret(bool value) {
  member_hmac_create_secret_ = value;
has_hmac_create_secret_ = true;
}

bool hasLargeBlob() const {
  return has_large_blob_;
}
AuthenticationExtensionsLargeBlobInputsJSON* largeBlob() const {
  DCHECK(hasLargeBlob());
return member_large_blob_.Get();
}
AuthenticationExtensionsLargeBlobInputsJSON* getLargeBlobOr(AuthenticationExtensionsLargeBlobInputsJSON* fallback_value) const {
  if (!hasLargeBlob()) {
  return fallback_value;
}
return member_large_blob_.Get();
}
void setLargeBlob(AuthenticationExtensionsLargeBlobInputsJSON* value) {
  member_large_blob_ = value;
has_large_blob_ = true;
DCHECK(member_large_blob_);
}

bool hasMinPinLength() const {
  return has_min_pin_length_;
}
bool minPinLength() const {
  DCHECK(hasMinPinLength());
return member_min_pin_length_;
}
bool getMinPinLengthOr(bool fallback_value) const {
  if (!hasMinPinLength()) {
  return fallback_value;
}
return member_min_pin_length_;
}
void setMinPinLength(bool value) {
  member_min_pin_length_ = value;
has_min_pin_length_ = true;
}

bool hasPayment() const {
  return has_payment_;
}
AuthenticationExtensionsPaymentInputs* payment() const {
  DCHECK(hasPayment());
return member_payment_.Get();
}
AuthenticationExtensionsPaymentInputs* getPaymentOr(AuthenticationExtensionsPaymentInputs* fallback_value) const {
  if (!hasPayment()) {
  return fallback_value;
}
return member_payment_.Get();
}
void setPayment(AuthenticationExtensionsPaymentInputs* value) {
  member_payment_ = value;
has_payment_ = true;
DCHECK(member_payment_);
}

bool hasPrf() const {
  return has_prf_;
}
AuthenticationExtensionsPRFInputsJSON* prf() const {
  DCHECK(hasPrf());
return member_prf_.Get();
}
AuthenticationExtensionsPRFInputsJSON* getPrfOr(AuthenticationExtensionsPRFInputsJSON* fallback_value) const {
  if (!hasPrf()) {
  return fallback_value;
}
return member_prf_.Get();
}
void setPrf(AuthenticationExtensionsPRFInputsJSON* value) {
  member_prf_ = value;
has_prf_ = true;
DCHECK(member_prf_);
}

bool hasRemoteDesktopClientOverride() const {
  return has_remote_desktop_client_override_;
}
RemoteDesktopClientOverride* remoteDesktopClientOverride() const {
  DCHECK(hasRemoteDesktopClientOverride());
return member_remote_desktop_client_override_.Get();
}
RemoteDesktopClientOverride* getRemoteDesktopClientOverrideOr(RemoteDesktopClientOverride* fallback_value) const {
  if (!hasRemoteDesktopClientOverride()) {
  return fallback_value;
}
return member_remote_desktop_client_override_.Get();
}
void setRemoteDesktopClientOverride(RemoteDesktopClientOverride* value) {
  member_remote_desktop_client_override_ = value;
has_remote_desktop_client_override_ = true;
DCHECK(member_remote_desktop_client_override_);
}

bool hasSupplementalPubKeys() const {
  return has_supplemental_pub_keys_;
}
AuthenticationExtensionsSupplementalPubKeysInputs* supplementalPubKeys() const {
  DCHECK(hasSupplementalPubKeys());
return member_supplemental_pub_keys_.Get();
}
AuthenticationExtensionsSupplementalPubKeysInputs* getSupplementalPubKeysOr(AuthenticationExtensionsSupplementalPubKeysInputs* fallback_value) const {
  if (!hasSupplementalPubKeys()) {
  return fallback_value;
}
return member_supplemental_pub_keys_.Get();
}
void setSupplementalPubKeys(AuthenticationExtensionsSupplementalPubKeysInputs* value) {
  member_supplemental_pub_keys_ = value;
has_supplemental_pub_keys_ = true;
DCHECK(member_supplemental_pub_keys_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 14;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_appid_ = false;
bool has_appid_exclude_ = false;
bool has_cred_blob_ = false;
bool has_credential_protection_policy_ = false;
bool has_get_cred_blob_ = false;
bool has_hmac_create_secret_ = false;
bool has_large_blob_ = false;
bool has_min_pin_length_ = false;
bool has_payment_ = false;
bool has_prf_ = false;
bool has_remote_desktop_client_override_ = false;
bool has_supplemental_pub_keys_ = false;

String member_appid_;
String member_appid_exclude_;
String member_cred_blob_;
bool member_cred_props_{false};
String member_credential_protection_policy_;
bool member_enforce_credential_protection_policy_{false};
bool member_get_cred_blob_;
bool member_hmac_create_secret_;
Member<AuthenticationExtensionsLargeBlobInputsJSON> member_large_blob_;
bool member_min_pin_length_;
Member<AuthenticationExtensionsPaymentInputs> member_payment_;
Member<AuthenticationExtensionsPRFInputsJSON> member_prf_;
Member<RemoteDesktopClientOverride> member_remote_desktop_client_override_;
Member<AuthenticationExtensionsSupplementalPubKeysInputs> member_supplemental_pub_keys_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUTHENTICATION_EXTENSIONS_CLIENT_INPUTS_JS_ON_H_
