// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_DECODER_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_DECODER_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared;

class MODULES_EXPORT AudioDecoderConfig : public bindings::DictionaryBase {
  
  public:
static AudioDecoderConfig* Create() {
  return MakeGarbageCollected<AudioDecoderConfig>();
}
static AudioDecoderConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioDecoderConfig>(isolate);
}
static AudioDecoderConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioDecoderConfig();
explicit  AudioDecoderConfig(v8::Isolate* isolate);

bool hasCodec() const {
  return true;
}
const String& codec() const {
  return member_codec_;
}
void setCodec(const String& value);
void setCodec(String&& value);

bool hasDescription() const {
  return has_description_;
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* description() const {
  DCHECK(hasDescription());
return member_description_.Get();
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* getDescriptionOr(V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* fallback_value) const {
  if (!hasDescription()) {
  return fallback_value;
}
return member_description_.Get();
}
void setDescription(V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* value) {
  member_description_ = value;
has_description_ = true;
DCHECK(member_description_);
}

bool hasEncryptionScheme() const {
  return has_encryption_scheme_;
}
const String& encryptionScheme() const {
  DCHECK(hasEncryptionScheme());
return member_encryption_scheme_;
}
String getEncryptionSchemeOr(const String& fallback_value) const;
String getEncryptionSchemeOr(String&& fallback_value) const;
void setEncryptionScheme(const String& value);
void setEncryptionScheme(String&& value);

bool hasNumberOfChannels() const {
  return true;
}
uint32_t numberOfChannels() const {
  return member_number_of_channels_;
}
void setNumberOfChannels(uint32_t value) {
  member_number_of_channels_ = value;
}

bool hasSampleRate() const {
  return true;
}
uint32_t sampleRate() const {
  return member_sample_rate_;
}
void setSampleRate(uint32_t value) {
  member_sample_rate_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_description_ = false;
bool has_encryption_scheme_ = false;

String member_codec_;
Member<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared> member_description_;
String member_encryption_scheme_;
uint32_t member_number_of_channels_;
uint32_t member_sample_rate_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_DECODER_CONFIG_H_
