// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_decoder_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybufferallowshared_arraybufferviewallowshared.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"codec",
"description",
"encryptionScheme",
"numberOfChannels",
"sampleRate",
};


}  // namespace 

AudioDecoderConfig* AudioDecoderConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AudioDecoderConfig* dictionary = MakeGarbageCollected<AudioDecoderConfig>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AudioDecoderConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AudioDecoderConfig::AudioDecoderConfig() {
  
}

 AudioDecoderConfig::AudioDecoderConfig(v8::Isolate* isolate) {
  
}



void AudioDecoderConfig::setCodec(const String& value) {
  member_codec_ = value;
}

void AudioDecoderConfig::setCodec(String&& value) {
  member_codec_ = std::move(value);
}











String AudioDecoderConfig::getEncryptionSchemeOr(const String& fallback_value) const {
  if (!hasEncryptionScheme()) {
  return fallback_value;
}
return member_encryption_scheme_;
}

String AudioDecoderConfig::getEncryptionSchemeOr(String&& fallback_value) const {
  if (!hasEncryptionScheme()) {
  return std::move(fallback_value);
}
return member_encryption_scheme_;
}

void AudioDecoderConfig::setEncryptionScheme(const String& value) {
  member_encryption_scheme_ = value;
has_encryption_scheme_ = true;
}

void AudioDecoderConfig::setEncryptionScheme(String&& value) {
  member_encryption_scheme_ = std::move(value);
has_encryption_scheme_ = true;
}














void AudioDecoderConfig::Trace(Visitor* visitor) const {
  visitor->Trace(member_description_);
bindings::DictionaryBase::Trace(visitor);
}

void AudioDecoderConfig::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void AudioDecoderConfig::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasCodec()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_codec_);
DCHECK(!values[0].IsEmpty());
}
if (hasDescription()) {
  values[1] = ToV8Traits<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared>::ToV8(script_state, member_description_.Get());
DCHECK(!values[1].IsEmpty());
}
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaSourceExtensionsForWebCodecsEnabled(execution_context)) {
  if (hasEncryptionScheme()) {
  values[2] = ToV8Traits<IDLString>::ToV8(script_state, member_encryption_scheme_);
DCHECK(!values[2].IsEmpty());
}
}
if (hasNumberOfChannels()) {
  values[3] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_number_of_channels_);
DCHECK(!values[3].IsEmpty());
}
if (hasSampleRate()) {
  values[4] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_sample_rate_);
DCHECK(!values[4].IsEmpty());
}
}

const void* AudioDecoderConfig::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> AudioDecoderConfig::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void AudioDecoderConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AudioDecoderConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("codec");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_codec_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("description");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_description_, member_description_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaSourceExtensionsForWebCodecsEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("encryptionScheme");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_encryption_scheme_, member_encryption_scheme_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("numberOfChannels");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_number_of_channels_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleRate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_sample_rate_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AudioDecoderConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
