// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_context_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_sink_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_audiocontextlatencycategory_double.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_audiocontextrendersizecategory_unsignedlong.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_audiosinkoptions_string.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"latencyHint",
"renderSizeHint",
"sampleRate",
"sinkId",
};


}  // namespace 

AudioContextOptions* AudioContextOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  AudioContextOptions* dictionary = MakeGarbageCollected<AudioContextOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "AudioContextOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 AudioContextOptions::AudioContextOptions() : member_latency_hint_(MakeGarbageCollected<V8UnionAudioContextLatencyCategoryOrDouble>(V8AudioContextLatencyCategory(V8AudioContextLatencyCategory::Enum::kInteractive))), member_render_size_hint_(MakeGarbageCollected<V8UnionAudioContextRenderSizeCategoryOrUnsignedLong>(V8AudioContextRenderSizeCategory(V8AudioContextRenderSizeCategory::Enum::kDefault))) {
  
}

 AudioContextOptions::AudioContextOptions(v8::Isolate* isolate) : member_latency_hint_(MakeGarbageCollected<V8UnionAudioContextLatencyCategoryOrDouble>(V8AudioContextLatencyCategory(V8AudioContextLatencyCategory::Enum::kInteractive))), member_render_size_hint_(MakeGarbageCollected<V8UnionAudioContextRenderSizeCategoryOrUnsignedLong>(V8AudioContextRenderSizeCategory(V8AudioContextRenderSizeCategory::Enum::kDefault))) {
  
}



























void AudioContextOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_latency_hint_);
visitor->Trace(member_render_size_hint_);
visitor->Trace(member_sink_id_);
bindings::InputDictionaryBase::Trace(visitor);
}

void AudioContextOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "AudioContextOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("latencyHint");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionAudioContextLatencyCategoryOrDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_latency_hint_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebAudioConfigurableRenderQuantumEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("renderSizeHint");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionAudioContextRenderSizeCategoryOrUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_render_size_hint_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleRate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLFloat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_sample_rate_, member_sample_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sinkId");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionAudioSinkOptionsOrString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_sink_id_, member_sink_id_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> AudioContextOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
