// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_BUFFER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_BUFFER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AudioBufferOptions : public bindings::InputDictionaryBase {
  
  public:
static AudioBufferOptions* Create() {
  return MakeGarbageCollected<AudioBufferOptions>();
}
static AudioBufferOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AudioBufferOptions>(isolate);
}
static AudioBufferOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AudioBufferOptions();
explicit  AudioBufferOptions(v8::Isolate* isolate);

bool hasLength() const {
  return true;
}
uint32_t length() const {
  return member_length_;
}
void setLength(uint32_t value) {
  member_length_ = value;
}

bool hasNumberOfChannels() const {
  return true;
}
uint32_t numberOfChannels() const {
  return member_number_of_channels_;
}
void setNumberOfChannels(uint32_t value) {
  member_number_of_channels_ = value;
}

bool hasSampleRate() const {
  return true;
}
float sampleRate() const {
  return member_sample_rate_;
}
void setSampleRate(float value) {
  member_sample_rate_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_length_;
uint32_t member_number_of_channels_{1};
float member_sample_rate_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUDIO_BUFFER_OPTIONS_H_
