// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_AD_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_AD_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AuctionAd : public bindings::DictionaryBase {
  
  public:
static AuctionAd* Create() {
  return MakeGarbageCollected<AuctionAd>();
}
static AuctionAd* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AuctionAd>(isolate);
}
static AuctionAd* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AuctionAd();
explicit  AuctionAd(v8::Isolate* isolate);

bool hasAdRenderId() const {
  return has_ad_render_id_;
}
const String& adRenderId() const {
  DCHECK(hasAdRenderId());
return member_ad_render_id_;
}
String getAdRenderIdOr(const String& fallback_value) const;
String getAdRenderIdOr(String&& fallback_value) const;
void setAdRenderId(const String& value);
void setAdRenderId(String&& value);

bool hasAllowedReportingOrigins() const {
  return has_allowed_reporting_origins_;
}
const Vector<String>& allowedReportingOrigins() const {
  DCHECK(hasAllowedReportingOrigins());
return member_allowed_reporting_origins_;
}
Vector<String> getAllowedReportingOriginsOr(const Vector<String>& fallback_value) const;
Vector<String> getAllowedReportingOriginsOr(Vector<String>&& fallback_value) const;
void setAllowedReportingOrigins(const Vector<String>& value);
void setAllowedReportingOrigins(Vector<String>&& value);

bool hasBuyerAndSellerReportingId() const {
  return has_buyer_and_seller_reporting_id_;
}
const String& buyerAndSellerReportingId() const {
  DCHECK(hasBuyerAndSellerReportingId());
return member_buyer_and_seller_reporting_id_;
}
String getBuyerAndSellerReportingIdOr(const String& fallback_value) const;
String getBuyerAndSellerReportingIdOr(String&& fallback_value) const;
void setBuyerAndSellerReportingId(const String& value);
void setBuyerAndSellerReportingId(String&& value);

bool hasBuyerReportingId() const {
  return has_buyer_reporting_id_;
}
const String& buyerReportingId() const {
  DCHECK(hasBuyerReportingId());
return member_buyer_reporting_id_;
}
String getBuyerReportingIdOr(const String& fallback_value) const;
String getBuyerReportingIdOr(String&& fallback_value) const;
void setBuyerReportingId(const String& value);
void setBuyerReportingId(String&& value);

bool hasCreativeScanningMetadata() const {
  return has_creative_scanning_metadata_;
}
const String& creativeScanningMetadata() const {
  DCHECK(hasCreativeScanningMetadata());
return member_creative_scanning_metadata_;
}
String getCreativeScanningMetadataOr(const String& fallback_value) const;
String getCreativeScanningMetadataOr(String&& fallback_value) const;
void setCreativeScanningMetadata(const String& value);
void setCreativeScanningMetadata(String&& value);

bool hasMetadata() const {
  return !member_metadata_.IsEmpty();
}
const ScriptValue& metadata() const {
  DCHECK(hasMetadata());
return member_metadata_;
}
ScriptValue getMetadataOr(const ScriptValue& fallback_value) const {
  if (!hasMetadata()) {
  return fallback_value;
}
return member_metadata_;
}
void setMetadata(const ScriptValue& value) {
  member_metadata_ = value;
}

bool hasRenderURL() const {
  return has_render_url_;
}
const String& renderURL() const {
  DCHECK(hasRenderURL());
return member_render_url_;
}
String getRenderURLOr(const String& fallback_value) const;
String getRenderURLOr(String&& fallback_value) const;
void setRenderURL(const String& value);
void setRenderURL(String&& value);

bool hasRenderUrlDeprecated() const {
  return has_render_url_deprecated_;
}
const String& renderUrlDeprecated() const {
  DCHECK(hasRenderUrlDeprecated());
return member_render_url_deprecated_;
}
String getRenderUrlDeprecatedOr(const String& fallback_value) const;
String getRenderUrlDeprecatedOr(String&& fallback_value) const;
void setRenderUrlDeprecated(const String& value);
void setRenderUrlDeprecated(String&& value);

bool hasSelectableBuyerAndSellerReportingIds() const {
  return has_selectable_buyer_and_seller_reporting_ids_;
}
const Vector<String>& selectableBuyerAndSellerReportingIds() const {
  DCHECK(hasSelectableBuyerAndSellerReportingIds());
return member_selectable_buyer_and_seller_reporting_ids_;
}
Vector<String> getSelectableBuyerAndSellerReportingIdsOr(const Vector<String>& fallback_value) const;
Vector<String> getSelectableBuyerAndSellerReportingIdsOr(Vector<String>&& fallback_value) const;
void setSelectableBuyerAndSellerReportingIds(const Vector<String>& value);
void setSelectableBuyerAndSellerReportingIds(Vector<String>&& value);

bool hasSizeGroup() const {
  return has_size_group_;
}
const String& sizeGroup() const {
  DCHECK(hasSizeGroup());
return member_size_group_;
}
String getSizeGroupOr(const String& fallback_value) const;
String getSizeGroupOr(String&& fallback_value) const;
void setSizeGroup(const String& value);
void setSizeGroup(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_ad_render_id_ = false;
bool has_allowed_reporting_origins_ = false;
bool has_buyer_and_seller_reporting_id_ = false;
bool has_buyer_reporting_id_ = false;
bool has_creative_scanning_metadata_ = false;
bool has_render_url_ = false;
bool has_render_url_deprecated_ = false;
bool has_selectable_buyer_and_seller_reporting_ids_ = false;
bool has_size_group_ = false;

String member_ad_render_id_;
Vector<String> member_allowed_reporting_origins_;
String member_buyer_and_seller_reporting_id_;
String member_buyer_reporting_id_;
String member_creative_scanning_metadata_;
ScriptValue member_metadata_;
String member_render_url_;
String member_render_url_deprecated_;
Vector<String> member_selectable_buyer_and_seller_reporting_ids_;
String member_size_group_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AUCTION_AD_H_
