// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ADDRESS_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ADDRESS_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AddressInit : public bindings::DictionaryBase {
  
  public:
static AddressInit* Create() {
  return MakeGarbageCollected<AddressInit>();
}
static AddressInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AddressInit>(isolate);
}
static AddressInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AddressInit();
explicit  AddressInit(v8::Isolate* isolate);

bool hasAddressLine() const {
  return has_address_line_;
}
const Vector<String>& addressLine() const {
  DCHECK(hasAddressLine());
return member_address_line_;
}
Vector<String> getAddressLineOr(const Vector<String>& fallback_value) const;
Vector<String> getAddressLineOr(Vector<String>&& fallback_value) const;
void setAddressLine(const Vector<String>& value);
void setAddressLine(Vector<String>&& value);

bool hasCity() const {
  return has_city_;
}
const String& city() const {
  DCHECK(hasCity());
return member_city_;
}
String getCityOr(const String& fallback_value) const;
String getCityOr(String&& fallback_value) const;
void setCity(const String& value);
void setCity(String&& value);

bool hasCountry() const {
  return has_country_;
}
const String& country() const {
  DCHECK(hasCountry());
return member_country_;
}
String getCountryOr(const String& fallback_value) const;
String getCountryOr(String&& fallback_value) const;
void setCountry(const String& value);
void setCountry(String&& value);

bool hasDependentLocality() const {
  return has_dependent_locality_;
}
const String& dependentLocality() const {
  DCHECK(hasDependentLocality());
return member_dependent_locality_;
}
String getDependentLocalityOr(const String& fallback_value) const;
String getDependentLocalityOr(String&& fallback_value) const;
void setDependentLocality(const String& value);
void setDependentLocality(String&& value);

bool hasOrganization() const {
  return has_organization_;
}
const String& organization() const {
  DCHECK(hasOrganization());
return member_organization_;
}
String getOrganizationOr(const String& fallback_value) const;
String getOrganizationOr(String&& fallback_value) const;
void setOrganization(const String& value);
void setOrganization(String&& value);

bool hasPhone() const {
  return has_phone_;
}
const String& phone() const {
  DCHECK(hasPhone());
return member_phone_;
}
String getPhoneOr(const String& fallback_value) const;
String getPhoneOr(String&& fallback_value) const;
void setPhone(const String& value);
void setPhone(String&& value);

bool hasPostalCode() const {
  return has_postal_code_;
}
const String& postalCode() const {
  DCHECK(hasPostalCode());
return member_postal_code_;
}
String getPostalCodeOr(const String& fallback_value) const;
String getPostalCodeOr(String&& fallback_value) const;
void setPostalCode(const String& value);
void setPostalCode(String&& value);

bool hasRecipient() const {
  return has_recipient_;
}
const String& recipient() const {
  DCHECK(hasRecipient());
return member_recipient_;
}
String getRecipientOr(const String& fallback_value) const;
String getRecipientOr(String&& fallback_value) const;
void setRecipient(const String& value);
void setRecipient(String&& value);

bool hasRegion() const {
  return has_region_;
}
const String& region() const {
  DCHECK(hasRegion());
return member_region_;
}
String getRegionOr(const String& fallback_value) const;
String getRegionOr(String&& fallback_value) const;
void setRegion(const String& value);
void setRegion(String&& value);

bool hasSortingCode() const {
  return has_sorting_code_;
}
const String& sortingCode() const {
  DCHECK(hasSortingCode());
return member_sorting_code_;
}
String getSortingCodeOr(const String& fallback_value) const;
String getSortingCodeOr(String&& fallback_value) const;
void setSortingCode(const String& value);
void setSortingCode(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_address_line_ = false;
bool has_city_ = false;
bool has_country_ = false;
bool has_dependent_locality_ = false;
bool has_organization_ = false;
bool has_phone_ = false;
bool has_postal_code_ = false;
bool has_recipient_ = false;
bool has_region_ = false;
bool has_sorting_code_ = false;

Vector<String> member_address_line_;
String member_city_;
String member_country_;
String member_dependent_locality_;
String member_organization_;
String member_phone_;
String member_postal_code_;
String member_recipient_;
String member_region_;
String member_sorting_code_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ADDRESS_INIT_H_
