// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_REQUEST_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_REQUEST_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_signals.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AdProperties;
class AdTargeting;
class ExceptionState;
class V8UnionAdPropertiesOrAdPropertiesSequence;

class MODULES_EXPORT AdRequestConfig : public bindings::InputDictionaryBase {
  
  public:
static AdRequestConfig* Create() {
  return MakeGarbageCollected<AdRequestConfig>();
}
static AdRequestConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AdRequestConfig>(isolate);
}
static AdRequestConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AdRequestConfig();
explicit  AdRequestConfig(v8::Isolate* isolate);

bool hasAdProperties() const {
  return true;
}
V8UnionAdPropertiesOrAdPropertiesSequence* adProperties() const {
  return member_ad_properties_.Get();
}
void setAdProperties(V8UnionAdPropertiesOrAdPropertiesSequence* value) {
  member_ad_properties_ = value;
DCHECK(member_ad_properties_);
}

bool hasAdRequestUrl() const {
  return true;
}
const String& adRequestUrl() const {
  return member_ad_request_url_;
}
void setAdRequestUrl(const String& value);
void setAdRequestUrl(String&& value);

bool hasAnonymizedProxiedSignals() const {
  return has_anonymized_proxied_signals_;
}
const Vector<V8AdSignals>& anonymizedProxiedSignals() const {
  DCHECK(hasAnonymizedProxiedSignals());
return member_anonymized_proxied_signals_;
}
Vector<V8AdSignals> getAnonymizedProxiedSignalsOr(const Vector<V8AdSignals>& fallback_value) const;
Vector<V8AdSignals> getAnonymizedProxiedSignalsOr(Vector<V8AdSignals>&& fallback_value) const;
void setAnonymizedProxiedSignals(const Vector<V8AdSignals>& value);
void setAnonymizedProxiedSignals(Vector<V8AdSignals>&& value);

bool hasFallbackSource() const {
  return has_fallback_source_;
}
const String& fallbackSource() const {
  DCHECK(hasFallbackSource());
return member_fallback_source_;
}
String getFallbackSourceOr(const String& fallback_value) const;
String getFallbackSourceOr(String&& fallback_value) const;
void setFallbackSource(const String& value);
void setFallbackSource(String&& value);

bool hasPublisherCode() const {
  return has_publisher_code_;
}
const String& publisherCode() const {
  DCHECK(hasPublisherCode());
return member_publisher_code_;
}
String getPublisherCodeOr(const String& fallback_value) const;
String getPublisherCodeOr(String&& fallback_value) const;
void setPublisherCode(const String& value);
void setPublisherCode(String&& value);

bool hasTargeting() const {
  return has_targeting_;
}
AdTargeting* targeting() const {
  DCHECK(hasTargeting());
return member_targeting_.Get();
}
AdTargeting* getTargetingOr(AdTargeting* fallback_value) const {
  if (!hasTargeting()) {
  return fallback_value;
}
return member_targeting_.Get();
}
void setTargeting(AdTargeting* value) {
  member_targeting_ = value;
has_targeting_ = true;
DCHECK(member_targeting_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_anonymized_proxied_signals_ = false;
bool has_fallback_source_ = false;
bool has_publisher_code_ = false;
bool has_targeting_ = false;

Member<V8UnionAdPropertiesOrAdPropertiesSequence> member_ad_properties_;
String member_ad_request_url_;
Vector<V8AdSignals> member_anonymized_proxied_signals_;
String member_fallback_source_;
String member_publisher_code_;
Member<AdTargeting> member_targeting_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_REQUEST_CONFIG_H_
