// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_PER_SELLER_DATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_PER_SELLER_DATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT AdAuctionPerSellerData : public bindings::DictionaryBase {
  
  public:
static AdAuctionPerSellerData* Create() {
  return MakeGarbageCollected<AdAuctionPerSellerData>();
}
static AdAuctionPerSellerData* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AdAuctionPerSellerData>(isolate);
}
static AdAuctionPerSellerData* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AdAuctionPerSellerData();
explicit  AdAuctionPerSellerData(v8::Isolate* isolate);

bool hasError() const {
  return has_error_;
}
const String& error() const {
  DCHECK(hasError());
return member_error_;
}
String getErrorOr(const String& fallback_value) const;
String getErrorOr(String&& fallback_value) const;
void setError(const String& value);
void setError(String&& value);

bool hasRequest() const {
  return has_request_;
}
NotShared<DOMUint8Array> request() const {
  DCHECK(hasRequest());
return member_request_;
}
NotShared<DOMUint8Array> getRequestOr(NotShared<DOMUint8Array> fallback_value) const {
  if (!hasRequest()) {
  return fallback_value;
}
return member_request_;
}
void setRequest(NotShared<DOMUint8Array> value) {
  member_request_ = value;
has_request_ = true;
DCHECK(member_request_);
}

bool hasSeller() const {
  return true;
}
const String& seller() const {
  return member_seller_;
}
void setSeller(const String& value);
void setSeller(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_error_ = false;
bool has_request_ = false;

String member_error_;
NotShared<DOMUint8Array> member_request_;
String member_seller_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_PER_SELLER_DATA_H_
