// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_DATA_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_DATA_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AdAuctionDataBuyerConfig;
class AdAuctionOneSeller;
class ExceptionState;

class MODULES_EXPORT AdAuctionDataConfig : public bindings::InputDictionaryBase {
  
  public:
static AdAuctionDataConfig* Create() {
  return MakeGarbageCollected<AdAuctionDataConfig>();
}
static AdAuctionDataConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<AdAuctionDataConfig>(isolate);
}
static AdAuctionDataConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  AdAuctionDataConfig();
explicit  AdAuctionDataConfig(v8::Isolate* isolate);

bool hasCoordinatorOrigin() const {
  return has_coordinator_origin_;
}
const String& coordinatorOrigin() const {
  DCHECK(hasCoordinatorOrigin());
return member_coordinator_origin_;
}
String getCoordinatorOriginOr(const String& fallback_value) const;
String getCoordinatorOriginOr(String&& fallback_value) const;
void setCoordinatorOrigin(const String& value);
void setCoordinatorOrigin(String&& value);

bool hasPerBuyerConfig() const {
  return has_per_buyer_config_;
}
const HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>>& perBuyerConfig() const {
  DCHECK(hasPerBuyerConfig());
return member_per_buyer_config_;
}
HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>> getPerBuyerConfigOr(const HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>>& fallback_value) const;
HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>> getPerBuyerConfigOr(HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>>&& fallback_value) const;
void setPerBuyerConfig(const HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>>& value);
void setPerBuyerConfig(HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>>&& value);

bool hasRequestSize() const {
  return has_request_size_;
}
uint32_t requestSize() const {
  DCHECK(hasRequestSize());
return member_request_size_;
}
uint32_t getRequestSizeOr(uint32_t fallback_value) const {
  if (!hasRequestSize()) {
  return fallback_value;
}
return member_request_size_;
}
void setRequestSize(uint32_t value) {
  member_request_size_ = value;
has_request_size_ = true;
}

bool hasSeller() const {
  return has_seller_;
}
const String& seller() const {
  DCHECK(hasSeller());
return member_seller_;
}
String getSellerOr(const String& fallback_value) const;
String getSellerOr(String&& fallback_value) const;
void setSeller(const String& value);
void setSeller(String&& value);

bool hasSellers() const {
  return has_sellers_;
}
const HeapVector<Member<AdAuctionOneSeller>>& sellers() const {
  DCHECK(hasSellers());
return member_sellers_;
}
HeapVector<Member<AdAuctionOneSeller>> getSellersOr(const HeapVector<Member<AdAuctionOneSeller>>& fallback_value) const;
HeapVector<Member<AdAuctionOneSeller>> getSellersOr(HeapVector<Member<AdAuctionOneSeller>>&& fallback_value) const;
void setSellers(const HeapVector<Member<AdAuctionOneSeller>>& value);
void setSellers(HeapVector<Member<AdAuctionOneSeller>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_coordinator_origin_ = false;
bool has_per_buyer_config_ = false;
bool has_request_size_ = false;
bool has_seller_ = false;
bool has_sellers_ = false;

String member_coordinator_origin_;
HeapVector<std::pair<String, Member<AdAuctionDataBuyerConfig>>> member_per_buyer_config_;
uint32_t member_request_size_;
String member_seller_;
HeapVector<Member<AdAuctionOneSeller>> member_sellers_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_AD_AUCTION_DATA_CONFIG_H_
