// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_WORKER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_WORKER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request_credentials.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_type.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT WorkerOptions : public bindings::InputDictionaryBase {
  
  public:
static WorkerOptions* Create() {
  return MakeGarbageCollected<WorkerOptions>();
}
static WorkerOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WorkerOptions>(isolate);
}
static WorkerOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WorkerOptions();
explicit  WorkerOptions(v8::Isolate* isolate);

bool hasCredentials() const {
  return true;
}
V8RequestCredentials credentials() const {
  return member_credentials_;
}
void setCredentials(V8RequestCredentials value) {
  member_credentials_ = value;
}
void setCredentials(V8RequestCredentials::Enum value) {
  member_credentials_ = V8RequestCredentials(value);
}

bool hasName() const {
  return true;
}
const String& name() const {
  return member_name_;
}
void setName(const String& value);
void setName(String&& value);

bool hasType() const {
  return true;
}
V8WorkerType type() const {
  return member_type_;
}
void setType(V8WorkerType value) {
  member_type_ = value;
}
void setType(V8WorkerType::Enum value) {
  member_type_ = V8WorkerType(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8RequestCredentials member_credentials_{V8RequestCredentials::Enum::kSameOrigin};
String member_name_{""};
V8WorkerType member_type_{V8WorkerType::Enum::kClassic};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_WORKER_OPTIONS_H_
